#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::Deep;
use Test::Partner2::Simple;

use Test::More;
use File::Slurp;

run_tests(
    sub {
        my ($app) = @_;

        my $methods = $app->get_cron_methods();

        foreach my $path (sort keys(%$methods)) {
            foreach my $method (keys(%{$methods->{$path}})) {
                my $package_name = $methods->{$path}{$method}{'package'};
                my $package = $package_name->new(app => $app);

                cmp_deeply($package->model_path(), $path, $package_name);
                last;
            }
        }

    },
    dont_create_database => 1,
    do_not_die_on_fail   => 1,
    application_package  => 'Cron',
);
