#!/usr/bin/perl

use Test::More;
use Test::Differences qw(eq_or_diff);

use qbit;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Capture::Tiny qw(capture_stdout);

my $STAGES = {
    frontend_prod     => {deploy_environment => 1, frontend_crons => 1, stage => 'production'},
    frontend_test     => {deploy_environment => 1, frontend_crons => 1, stage => 'test'},
    frontend_preprod  => {deploy_environment => 1, frontend_crons => 1, stage => 'preprod'},
    frontend_autotest => {deploy_environment => 1, frontend_crons => 1, stage => 'autotest'},
    production        => {stage              => 'production',},
    test              => {stage              => 'test',},
    preprod_deploy    => {deploy_environment => 1, stage => 'preprod',},
    production_deploy => {deploy_environment => 1, stage => 'production',},
    test_deploy       => {deploy_environment => 1, stage => 'test',},
};

plan tests => 1 + scalar keys %$STAGES;

run_tests(
    sub {
        my ($app) = @_;

        foreach my $stage (keys %$STAGES) {
            $app->set_option(%{$STAGES->{$stage}});

            my $stdout = capture_stdout {
                $app->generate_crond(
                    mail_to              => 'partner2-cron@yandex-team.ru',
                    user                 => 'partners',
                    lib_path             => '/usr/share/partners/local/lib/perl5',
                    application_path     => '/usr/share/partners/lib',
                    logs_path            => '/var/log/partners.yandex.ru',
                    stdout_log_file_name => 'partner2-cron-{path}-{method}.log',
                    %{$STAGES->{$stage}},
                );
            };

            my $expected = get_test_data_and_update_if_needed("${stage}.dump", $stdout, raw => TRUE);
            eq_or_diff($stdout, $expected, "check $stage");
        }
    },
    dont_create_database => 1,
    do_not_die_on_fail   => 1,
    application_package  => 'Cron',
);
