#!/usr/bin/perl

use Test::More;
use Test::Differences qw(eq_or_diff);

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs restore_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Partner2::Juggler::API;

BEGIN {
    no warnings 'redefine';
    no strict 'refs';

    # mocking passing Date param to Schedule::Cron::Events constructor
    # so test will pass even if it was started after 23:00
    # bc after 23:00 intervals between certain crons start to vary
    #
    # with this value in Date test will pass
    my $before_23 = [13, 11, 11, 01, 03, 119];
    # with this value in Date test will fail
    my $after_23 = [13, 11, 23, 01, 03, 119];

    my $sub_new_orig = \&Schedule::Cron::Events::new;

    *{'Schedule::Cron::Events::new'} = sub {
        return $sub_new_orig->(@_, ('Date' => $before_23));
    };
}

my @STAGES = qw(
  preprod
  production
  test
  );

plan tests => 1 + scalar @STAGES;

run_tests(
    sub {
        my ($app) = @_;

        my $api_juggler = $app->get_option('api_juggler');
        my $pja         = Partner2::Juggler::API->new(
            juggler_token => 'juggler-token',
            host          => $api_juggler->{'host'},
            namespace     => $api_juggler->{'namespace'},
        );

        foreach my $stage (@STAGES) {
            my @checks = ();
            mock_subs(
                {
                    'Partner2::Juggler::API::add_or_update' => sub {
                        my ($self, %opts) = @_;
                        push(@checks, \%opts);
                      }
                }
            );

            $app->generate_juggler($pja, stage => $stage);
            my $expected = get_test_data_and_update_if_needed("${stage}.json", \@checks);

            eq_or_diff(\@checks, $expected, "check $stage");
            restore_subs(['Partner2::Juggler::API::add_or_update']);
        }
    },
    dont_create_database => 1,
    do_not_die_on_fail   => 1,
    application_package  => 'Cron',
);
