#!/usr/bin/perl -w

use Test::Most;
use Test::Partner2::Simple;
use Test::Differences;
use Test::Deep;

use qbit;

my $PATH_NAME   = 'awaps';
my $METHOD_NAME = 'rtb_list';

sub check_data {
    my ($app, $sub, $api) = @_;

    my $response = $sub->($api);

    my $data = [
        sort {$a->{PageID} <=> $b->{PageID}}{
            'Blocks' => 'R-V-128972-1',
            'DSP'    => '1',
            'Domain' => 'kinopoisk.ru',
            'PageID' => '128972',
            'State'  => 'stopped'
        },
        {
            'Blocks' => 'R-A-41443-1,R-A-41443-100000',
            'DSP'    => '1',
            'Domain' => 'showmethemoney.ru',
            'PageID' => '41443',
            'State'  => 'work'
        },
        {
            'Blocks' => 'R-V-154689-2,R-V-154689-3,R-V-154689-4',
            'DSP'    => '1',
            'Domain' => 'newsru.com',
            'PageID' => '154689',
            'State'  => 'work'
        },
        {
            'Blocks' => 'R-M-43569-1',
            'DSP'    => '1',
            'Domain' => 'app.test.com',
            'PageID' => '43569',
            'State'  => 'work'
        },
        {
            'Blocks' => 'R-M-153980-2',
            'DSP'    => '1',
            'Domain' => 'test.com',
            'PageID' => '153980',
            'State'  => 'work'
        },
    ];

    my $got_data = [sort {$a->{PageID} <=> $b->{PageID}} @{delete $response->{'data'}}];
    eq_or_diff(
        $response,
        {
            fields  => [qw(PageID Domain State DSP Blocks)],
            options => {with_headers => 1},
        },
        'Headers are ok'
    );

    eq_or_diff($got_data, $data, 'Content is ok');
}

run_tests(
    sub {
        my ($app) = @_;

        my $methods = $app->get_methods();

        my $api = $methods->{$PATH_NAME}{$METHOD_NAME}{'package'}->new(
            app   => $app,
            path  => $PATH_NAME,
            attrs => $methods->{$PATH_NAME}{$METHOD_NAME}->{'attrs'}
        );

        my $sub = $methods->{$PATH_NAME}{$METHOD_NAME}{'sub'};

        check_data($app, $sub, $api);
    },
    application_package => 'IntAPI',
);
