use qbit;
use Test::More;

require IntAPI::Method::AdFox;

is_deeply(
    [IntAPI::Method::AdFox::_relaxed_public_id_split(undef, '12345-6')],
    ['12345', '6'],
    'check _relaxed_public_id_split no prefix',
);

is_deeply(
    [IntAPI::Method::AdFox::_relaxed_public_id_split(undef, 'bla-bla-bla-12345-67')],
    ['12345', '67'],
    'check _relaxed_public_id_split correct prefix',
);

eval {my @data = IntAPI::Method::AdFox::_relaxed_public_id_split(undef, '-12345-6');};

like("$@", qr/Exception::Validation::BadArguments/, 'check _relaxed_public_id_split incorrect prefix');

done_testing();
