#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::More;
use Test::Deep;

use qbit;

my $PATH_NAME   = 'adfox';
my $METHOD_NAME = 'delete_block';

run_tests(
    sub {
        my ($app) = @_;

        use_perl_do_actions($app, 'context_on_site_rtb');
        use_perl_do_actions($app, 'internal_context_on_site_rtb');
        use_perl_do_actions($app, 'mobile_app_rtb');
        use_perl_do_actions($app, 'internal_mobile_app_rtb');

        my ($header, $out) = request_to_intapi(
            app          => $app,
            path         => $PATH_NAME,
            method       => $METHOD_NAME,
            query_string => 'lang=ru&block_id=R-AF-1262-4',
            mode         => 'only_stdout',
        );

        ok($header, qq{Status: 400 Bad request\nContent-Type: application/json; charset=UTF-8});

        cmp_deeply(
            from_json($out),
            {
                'data' => {
                    'error_type' => 'Not Found',
                    'message'    => "Блок не найден",
                    'result'     => 'error'
                },
                'result' => 'ok'
            },
            'Block not Found'
        );

        ($header, $out) = request_to_intapi(
            app          => $app,
            path         => $PATH_NAME,
            method       => $METHOD_NAME,
            query_string => 'lang=ru&block_id=R-A-142898-1',
            mode         => 'only_stdout',
        );

        ok($header, qq{Status: 200 OK\nContent-Type: application/json; charset=UTF-8});

        cmp_deeply(
            from_json($out),
            {
                'data'   => {'result' => 'ok'},
                'result' => 'ok'
            },
            'RTB Block deleted'
        );

        ($header, $out) = request_to_intapi(
            app          => $app,
            path         => $PATH_NAME,
            method       => $METHOD_NAME,
            query_string => 'lang=ru&block_id=R-VF-128972-4',
            mode         => 'only_stdout',
        );

        ok($header, qq{Status: 200 OK\nContent-Type: application/json; charset=UTF-8});

        cmp_deeply(
            from_json($out),
            {
                'data'   => {'result' => 'ok'},
                'result' => 'ok'
            },
            'VideoAnSiteFullscreen Block deleted'
        );
    },
    application_package => 'IntAPI',
    init                => [qw(intapi_acl)]
);
