#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed request_to_intapi set_model_status);
use Test::Differences qw(eq_or_diff);

use qbit;

my $PATH_NAME   = 'adfox';
my $METHOD_NAME = 'get_deleted_blocks';

run_tests(
    sub {
        my ($app) = @_;

        set_model_status(
            $app,
            [
                map {{model => $_, filter => {adfox_block => 1}, order_by => ['id'], limit => 1, status => 'deleted'}}
                  @{$app->product_manager->get_adfox_blocks_model_accessors()}
            ]
        );

        my ($header, $body) = request_to_intapi(
            app          => $app,
            path         => $PATH_NAME,
            method       => $METHOD_NAME,
            query_string => 'pretty=1',
            mode         => 'only_stdout',
        );

        my $expected = get_test_data_and_update_if_needed('out.data', $body, raw => TRUE);

        eq_or_diff($body, $expected, 'response is correct', {context => 5});
    },
    application_package => 'IntAPI',
    init                => [qw(intapi_acl)]
);
