#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::More;
use Test::Deep;

use qbit;

my $PATH_NAME   = 'adfox';
my $METHOD_NAME = 'link_user';

run_tests(
    sub {
        my ($app) = @_;

        my ($header, $out) = request_to_intapi(
            app          => $app,
            path         => $PATH_NAME,
            method       => $METHOD_NAME,
            ext          => 'adfox',
            query_string => 'user_id=221582016&adfox_id=165596',
            mode         => 'only_stdout',
        );

        cmp_deeply(
            $header,
            qq{Status: 400 Bad request\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8},
            'Unknown user_id status - ok'
        );

        cmp_deeply(
            from_json($out),
            {
                "error_type" => "Exception::Validation::BadArguments",
                "message"    => gettext('Unknown user_id'),
                "result"     => "error"
            },
            'Unknown user_id - ok'
        );

        {
            no warnings 'redefine';
            no strict 'refs';

            *{'LWP::UserAgent::request'} = sub {
                my ($mock, $request) = @_;

                my $r = HTTP::Response->new(200);
                $r->request($request);
                $r->content('{"userInfo":{"login":"login"}}');
                return $r;
            };
        }

        ($header, $out) = request_to_intapi(
            app          => $app,
            path         => $PATH_NAME,
            method       => $METHOD_NAME,
            ext          => 'adfox',
            query_string => 'user_id=155209804&adfox_id=165596',
            mode         => 'only_stdout',
        );

        cmp_deeply(
            $header,
            qq{Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8},
            'Link status - ok'
        );

        cmp_deeply(
            from_json($out),
            {
                adfox_id => 165596,
                user_id  => 155209804,
            },
            'Link - ok'
        );

        ($header, $out) = request_to_intapi(
            app          => $app,
            path         => $PATH_NAME,
            method       => $METHOD_NAME,
            ext          => 'adfox',
            query_string => 'user_id=155209804&adfox_id=165596',
            mode         => 'only_stdout',
        );

        cmp_deeply(
            $header,
            qq{Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8},
            'Relink status - ok'
        );

        cmp_deeply(
            from_json($out),
            {
                adfox_id => 165596,
                user_id  => 155209804,
            },
            'Relink - ok'
        );

    },
    application_package => 'IntAPI',
    init                => [qw(intapi_acl)]
);
