#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::More;
use Test::Deep;

use qbit;

my $PATH_NAME   = 'adfox';
my $METHOD_NAME = 'unlink_user';

run_tests(
    sub {
        my ($app) = @_;

        my ($header, $out) = request_to_intapi(
            app          => $app,
            path         => $PATH_NAME,
            method       => $METHOD_NAME,
            ext          => 'adfox',
            query_string => 'user_id=221582016&adfox_id=165596',
            mode         => 'only_stdout',
        );

        cmp_deeply(
            $header,
            qq{Status: 400 Bad request\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8},
            'Unknown user_id status 400 - ok'
        );

        cmp_deeply(
            from_json($out),
            {
                "error_type" => "Exception::Validation::BadArguments",
                "message"    => gettext('Unknown user_id'),
                "result"     => "error"
            },
            'Unknown user_id errmsg- ok'
        );

        ($header, $out) = request_to_intapi(
            app          => $app,
            path         => $PATH_NAME,
            method       => $METHOD_NAME,
            ext          => 'adfox',
            query_string => 'user_id=155209804&adfox_id=165596',
            mode         => 'only_stdout',
        );

        cmp_deeply(
            $header,
            qq{Status: 400 Bad request\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8},
            'Unknown adfox_id status 400 - ok'
        );

        cmp_deeply(
            from_json($out),
            {
                "error_type" => "Exception::Validation::BadArguments",
                "message"    => gettext('Unknown adfox_id'),
                "result"     => "error"
            },
            'Unknown adfox_id errmsg - ok'
        );

        ($header, $out) = request_to_intapi(
            app          => $app,
            path         => $PATH_NAME,
            method       => $METHOD_NAME,
            ext          => 'adfox',
            query_string => 'user_id=1009&adfox_id=111009',
            mode         => 'only_stdout',
        );

        cmp_deeply(
            $header,
            qq{Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8},
            'unlink status 200 - ok'
        );

        cmp_deeply(from_json($out), 1, 'unlink - ok');

        ($header, $out) = request_to_intapi(
            app          => $app,
            path         => $PATH_NAME,
            method       => $METHOD_NAME,
            ext          => 'adfox',
            query_string => 'user_id=1009&adfox_id=111009',
            mode         => 'only_stdout',
        );

        cmp_deeply(
            $header,
            qq{Status: 400 Bad request\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8},
            'unlink unlinked status 400 - ok'
        );

        cmp_deeply(
            from_json($out),
            {
                "error_type" => "Exception::Validation::BadArguments",
                "message"    => gettext('Unknown adfox_id'),
                "result"     => "error"
            },
            'unlink unlinked errmsg - ok'
        );

    },
    application_package => 'IntAPI',
);
