#!/usr/bin/perl -w

use Test::Most;
use Test::Partner2::Simple;
use Test::Deep;
use Test::Differences;

use qbit;

my $PATH_NAME   = 'antifrod';
my $METHOD_NAME = 'page_owner_report';

sub check_data {
    my ($app, $sub, $api) = @_;

    my $response = $sub->($api, date => '2016-08-26');

    my $data = [
        {
            'assistants' => '1018',
            'login'      => 'mocked-yan-partner',
            'owner_id'   => '1009',
            'page_id'    => '41443'
        },
        {
            'assistants' => undef,
            'login'      => 'mocked-yan-partner',
            'owner_id'   => '1009',
            'page_id'    => '799'
        },
        {
            'assistants' => undef,
            'login'      => 'mocked-video-partner',
            'owner_id'   => '1010',
            'page_id'    => '801'
        },
        {
            'assistants' => '1018',
            'login'      => 'mocked-context-adblock-partner',
            'owner_id'   => '1016',
            'page_id'    => '153745'
        },
        {
            'assistants' => undef,
            'login'      => 'tutby-partner',
            'owner_id'   => '1024',
            'page_id'    => '802'
        },
        {
            'assistants' => undef,
            'login'      => 'tutby-partner-with-agreement',
            'owner_id'   => '1025',
            'page_id'    => '804'
        },
        {
            'assistants' => undef,
            'login'      => 'mocked-mobile-app-partner',
            'owner_id'   => '1011',
            'page_id'    => '43569'
        },
        {
            'assistants' => undef,
            'login'      => 'tutby-partner-with-agreement',
            'owner_id'   => '1025',
            'page_id'    => '213953'
        },
        {
            'assistants' => undef,
            'login'      => 'rubiconproject2015',
            'owner_id'   => '345321935',
            'page_id'    => '154198'
        },
        {
            'assistants' => undef,
            'login'      => 'smaato',
            'owner_id'   => '345331106',
            'page_id'    => '153979'
        },
        {
            'assistants' => undef,
            'login'      => 'smaato',
            'owner_id'   => '345331106',
            'page_id'    => '153980'
        },
        {
            'assistants' => undef,
            'login'      => 'mocked-video-partner',
            'owner_id'   => '1010',
            'page_id'    => '128972'
        },
        {
            'assistants' => undef,
            'login'      => 'mocked-video-partner',
            'owner_id'   => '1010',
            'page_id'    => '154689'
        },
        {
            'assistants' => undef,
            'login'      => 'tutby-partner-with-agreement',
            'owner_id'   => '1025',
            'page_id'    => '154690'
        },
        {
            'assistants' => undef,
            'login'      => 'rubiconproject2015',
            'owner_id'   => '345321935',
            'page_id'    => '155561'
        },
        {
            'assistants' => undef,
            'login'      => 'mocked-internal-manager',
            'owner_id'   => '1023',
            'page_id'    => '40'
        },
        {
            'assistants' => undef,
            'login'      => 'mocked-outdoor-partner',
            'owner_id'   => '1030',
            'page_id'    => '400'
        },
        {
            'assistants' => undef,
            'login'      => 'adinside',
            'owner_id'   => '54519301',
            'page_id'    => '148805'
        },
        {
            'assistants' => undef,
            'login'      => 'adinside',
            'owner_id'   => '54519301',
            'page_id'    => '132439'
        },
        {
            'assistants' => undef,
            'login'      => 'mocked-indoor-partner',
            'owner_id'   => '1028',
            'page_id'    => '41'
        },
        {
            'assistants' => 1036,
            'login'      => 'mocked-yan-partner-wo',
            'owner_id'   => '1034',
            'page_id'    => '153744'
        },
        {
            'assistants' => undef,
            'login'      => 'gomailru-ads',
            'owner_id'   => 217912896,
            'page_id'    => 444190,
        },
        {
            'assistants' => undef,
            'login'      => 'mail-gg-news',
            'owner_id'   => 995562330,
            'page_id'    => 509536,
        },
    ];
    eq_or_diff(
        [sort {$a->{page_id} <=> $b->{page_id}} @{delete $response->{'data'}}],
        [sort {$a->{page_id} <=> $b->{page_id}} @$data],
        'Content is ok'
    );
    eq_or_diff(
        $response,
        {
            fields  => [qw(page_id login owner_id assistants)],
            options => {with_headers => 1},
        },
        'Headers are ok'
    );

}

run_tests(
    sub {
        my ($app) = @_;

        my $methods = $app->get_methods();

        my $api = $methods->{$PATH_NAME}{$METHOD_NAME}{'package'}->new(
            app   => $app,
            path  => $PATH_NAME,
            attrs => $methods->{$PATH_NAME}{$METHOD_NAME}->{'attrs'}
        );

        my $sub = $methods->{$PATH_NAME}{$METHOD_NAME}{'sub'};

        check_data($app, $sub, $api);
    },
    application_package => 'IntAPI',
    do_not_die_on_fail  => 1,
);
