#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Partner::Utils;
use Test::Differences;

use qbit;

my $PATH_NAME   = 'bk';
my $METHOD_NAME = 'add_notification';

run_tests(
    sub {
        my ($app) = @_;

        my $path_to_data = lib::abs::path('add_notification/data.json');
        my $json_data    = from_json(readfile($path_to_data));

        my $data;
        for my $test (@{$json_data->{tests}}) {
            my ($header, $out) = request_to_intapi(
                app            => $app,
                path           => $PATH_NAME,
                method         => $METHOD_NAME,
                request_method => 'POST',
                content_type   => 'application/json',
                query_string   => '',
                mode           => 'split_json_answer',
                body           => to_json($test),
            );
            push @{$data}, $out;
        }

        eq_or_diff($data, $json_data->{result}, 'add notification');

        # Usage: > ./prove *.t :: --self_update 2>&1 | less
        if (need_self_update()) {
            $json_data->{result} = $data;
            writefile($path_to_data, to_json($json_data, pretty => TRUE));
        }
    },
    application_package => 'IntAPI',
    do_not_die_on_fail  => TRUE,
);
