#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Partner::Utils;
use Test::Differences;

use qbit;

my $PATH_NAME   = 'bk';
my $METHOD_NAME = 'list_dsp';

run_tests(
    sub {
        my ($app) = @_;

        my $path_to_data = lib::abs::path('list_dsp/data.json');
        my $json_data    = from_json(readfile($path_to_data));

        my %data;
        for my $login (@{$json_data->{logins}}) {
            my ($header, $out) = request_to_intapi(
                app          => $app,
                path         => $PATH_NAME,
                method       => $METHOD_NAME,
                query_string => 'login=' . $login,
                mode         => 'split_json_answer',
            );
            $out->{data} = [sort {$a->{id} cmp $b->{id}} @{$out->{data}}] if $out->{data};
            $data{$login} = $out;
        }

        eq_or_diff(\%data, $json_data->{result}, 'list dsp');

        # Usage: > ./prove *.t :: --self_update 2>&1 | less
        if (need_self_update()) {
            $json_data->{result} = \%data;
            writefile($path_to_data, to_json($json_data, pretty => TRUE));
        }
    },
    application_package => 'IntAPI',
    do_not_die_on_fail  => TRUE,
);
