#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Differences;
use Test::More;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my @by_format = (
            {
                format  => 'tsv',
                cb_in   => sub {return $_[0];},
                cb_out  => sub {return $_[0];},
                cb_sort => sub {
                    my @d = map {[split "\t", $_]} split "\n", $_[0];
                    @d = ($d[0], sort {$a->[3] cmp $b->[3] or $a->[0] cmp $b->[0] or $a->[1] cmp $b->[1]} @d[1 .. $#d]);
                    $_[0] = join("\n", map {join("\t", @$_)} @d);
                    return $_[0];
                },
                intapi_mode  => 'only_stdout',
                query_string => 'lang=ru',
                content_type => 'text/plain',
            },
            {
                format => 'json',
                cb_in  => sub {
                    return from_json($_[0]);
                },
                cb_out => sub {
                    return to_json($_[0], pretty => TRUE);
                },
                cb_sort => sub {
                    $_[0]->{data}{data} = [
                        sort {
                                 $a->{aggr_uid} cmp $b->{aggr_uid}
                              or $a->{page_id} cmp $b->{page_id}
                              or $a->{from} cmp $b->{from}
                          } @{$_[0]->{data}{data}}
                    ];
                    return $_[0];
                },
                intapi_mode  => 'split_json_answer',
                query_string => 'lang=ru&pretty=1',
                content_type => 'application/json',
            },
        );

        for my $cfg (@by_format) {
            my $path_to_data = lib::abs::path("billing_report/data.$cfg->{format}");

            my $expected_data = readfile($path_to_data);
            $expected_data = $cfg->{cb_in}->($expected_data);

            my ($header, $got_data) = request_to_intapi(
                app          => $app,
                path         => 'balance',
                method       => 'billing_report',
                ext          => $cfg->{format},
                query_string => $cfg->{query_string},
                mode         => $cfg->{intapi_mode},
            );

            is($header,
                "Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: $cfg->{content_type}; charset=UTF-8",
                'header');
            $got_data = $cfg->{cb_sort}->($got_data);

            eq_or_diff($got_data, $expected_data, "body $cfg->{format}");

            # Usage: > ./prove *.t :: --self_update 2>&1 | less
            if (need_self_update()) {
                writefile($path_to_data, $cfg->{cb_out}->($got_data));
            }
        }
    },
    application_package => 'IntAPI',
    init                => [qw(intapi_acl)],
    do_not_die_on_fail  => TRUE,
);
