#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Deep;
use Test::More tests => 9;
use Test::Partner::Utils;

use qbit;

my $PATH_NAME   = 'form';
my $METHOD_NAME = 'create_offer';

run_tests(
    sub {
        my ($app) = @_;

        $app->api_balance;
        $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

        no strict 'refs';
        no warnings 'redefine';

        *{'Application::Model::Users::check_pi_adfox_contracts'} = sub {
            return {
                adfox_contract => {
                    Client      => {},
                    Collaterals => {},
                    Contract    => {
                        contract2_id => 13579,
                        external_id  => 'external adfox contract',
                    },
                    Person => {},
                },
                pi_contract => undef,
            };
        };

        $app->api_balance->mock(
            'call',
            sub {
                my ($self, $method, $operator_uid, $opts) = @_;

                is($method, 'Balance2.CreateOffer', 'running Balance2.CreateOffer');
                is($operator_uid, 536141962, 'expected operator_uid in Balance2.CreateOffer');

                cmp_deeply(
                    $opts,
                    {
                        'client_id'        => 35033364,
                        'ctype'            => 'PARTNERS',
                        'currency'         => 'RUB',
                        'firm_id'          => 1,
                        'nds'              => 18,
                        'operator_uid'     => 536141962,
                        'partner_pct'      => 43,
                        'payment_type'     => 1,
                        'person_id'        => ignore(),
                        'service_start_dt' => '2018-05-03',
                        'signed'           => 1,
                        'start_dt'         => '2018-05-03',
                        'test_mode'        => 0
                    },

                    'expected data in Balance2.CreateOffer',
                );

                return [{EXTERNAL_ID => 'РС-64233-05/18', ID => 611822}];
            }
        );
        $app->api_balance->mock('close_contract', sub { });

        my ($header1, $out1) = request_to_intapi(
            app            => $app,
            path           => $PATH_NAME,
            method         => $METHOD_NAME,
            request_method => 'POST',
            content_type   => 'application/json',
            query_string   => '',
            mode           => 'only_stdout',
            body           => to_json(
                {
                    adfox_account => {
                        adfox_offer => 1,
                        has_account => 1,
                        login       => 'adfox login',
                        password    => undef,
                    },
                    client_id        => 35033364,
                    ctype            => 'PARTNERS',
                    currency         => 'RUB',
                    firm_id          => 1,
                    login            => 'pi login',
                    nds              => 18,
                    operator_uid     => 536141962,
                    partner_pct      => 43,
                    payment_type     => 1,
                    person_id        => 6628302,
                    service_start_dt => '2018-05-03',
                    signed           => 1,
                    start_dt         => '2018-05-03',
                    test_mode        => 0,
                }
            ),
        );

        is(
            $header1,
            "Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
            'got expected header'
          );
        is_deeply(
            from_json($out1)->{data},
            {contract => {EXTERNAL_ID => 'РС-64233-05/18', ID => 611822}},
            'got expected answer',
        );

        my ($header2, $out2) = request_to_intapi(
            app            => $app,
            path           => $PATH_NAME,
            method         => $METHOD_NAME,
            request_method => 'POST',
            content_type   => 'application/json',
            query_string   => '',
            mode           => 'split_json_answer',
            body           => 'not a valid json',
        );

        is(
            $header2,
            "Status: 400 Bad request\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
            'got expected header'
          );
        is_deeply(
            $out2,
            {
                error_type => 'Exception::Validation::BadArguments',
                message    => 'Body must be a valid json',
                result     => 'error',
            },
            'got expected answer',
        );

    },
    application_package => 'IntAPI',
    init                => [qw(api_balance intapi_acl users)],
    locale              => 'C',
);
