#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Deep;
use Test::Partner::Utils;
use Data::Dumper;

use qbit;

my $PATH_NAME   = 'form';
my $METHOD_NAME = 'create_person';

run_tests(
    sub {
        my ($app) = @_;

        $app->api_balance;
        $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

        $app->api_balance->mock(
            'call',
            sub {
                my ($self, $method, $operator_uid, $opts) = @_;

                is($method, 'Balance2.CreatePerson', 'running Balance2.CreatePerson');
                is($operator_uid, 123, 'expected operator_uid in Balance2.CreatePerson');
                cmp_deeply(
                    $opts,
                    {
                        'client_id'    => ignore(),
                        'email'        => 'aa@yandex.ru',
                        'name'         => 'name',
                        'operator_uid' => 123,
                        'person_id'    => ignore(),
                        'postcode'     => 'postcode',
                        'type'         => 'sw_yt'
                    },
                    'expected data in Balance2.CreatePerson',
                );
                is($opts->{person_id}->{_value}[0], -1);
                is($opts->{client_id}->{_value}[0], 123);

                my $person_id = 6690573;
                return [$person_id];
            }
        );

        my ($header1, $out1) = request_to_intapi(
            app            => $app,
            path           => $PATH_NAME,
            method         => $METHOD_NAME,
            request_method => 'POST',
            content_type   => 'application/json',
            query_string   => '',
            mode           => 'only_stdout',
            body           => to_json(
                {
                    client_id    => 123,
                    email        => 'aa@yandex.ru',
                    name         => 'name',
                    operator_uid => 123,
                    person_id    => -1,
                    postcode     => 'postcode',
                    type         => 'sw_yt',
                }
            ),
        );

        is(
            $header1,
            "Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
            'got expected header'
          );
        is_deeply(from_json($out1)->{data}, {person_id => 6690573}, 'got expected answer',);

        my ($header2, $out2) = request_to_intapi(
            app             => $app,
            path            => $PATH_NAME,
            method          => $METHOD_NAME,
            request_method  => 'POST',
            content_type    => 'application/json',
            accept_language => 'en',
            mode            => 'only_stdout',
            body            => to_json(
                {
                    client_id    => 123,
                    email        => 'aa@yandex.ru',
                    name         => 'name',
                    operator_uid => 123,
                    postcode     => 'postcode',
                    type         => 'sw_yt',
                }
            ),
        );

        is(
            $header2,
            "Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
            'got expected header'
          );

        is_deeply(
            from_json(from_json($out2)->{data}->{error_message}),
            [
                {
                    messages => [gettext('Key "%s" required', 'person_id'),],
                    name     => ['person_id',],
                },
            ],
            'got expected error answer',
        );

    },
    application_package => 'IntAPI',
    init                => [qw(api_balance intapi_acl)],
    locale              => 'C',
);
