#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Deep;
use Test::Partner::Utils;

use qbit;

my $PATH_NAME   = 'form';
my $METHOD_NAME = 'fias_hierarchy';

run_tests(
    sub {
        my ($app) = @_;

        cmp_deeply(
            [
                request_to_intapi(
                    app            => $app,
                    path           => $PATH_NAME,
                    method         => $METHOD_NAME,
                    request_method => 'GET',
                    content_type   => 'application/json',
                    query_string   => '',
                    mode           => 'split_json_answer',
                )
            ],
            [
"Status: 400 Bad request\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
                {
                    error_type => 'Exception::Validation::BadArguments',
                    message    => 'Отсутствует обязательный параметр "guid"',
                    result     => 'error',
                },
            ],
            'error - must specify guid',
        );

        cmp_deeply(
            [
                request_to_intapi(
                    app            => $app,
                    path           => $PATH_NAME,
                    method         => $METHOD_NAME,
                    request_method => 'GET',
                    content_type   => 'application/json',
                    query_string   => 'guid=0560cfb6-d931-4bb8-93f0-1889a5fc4a9a',
                    mode           => 'split_json_answer',
                )
            ],
            [
                "Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
                {
                    data => [
                        {
                            formal_name => 'Хохрякова',
                            guid        => '0560cfb6-d931-4bb8-93f0-1889a5fc4a9a',
                            obj_level   => 7,
                            parent_guid => '2763c110-cb8b-416a-9dac-ad28a55b4402',
                            short_name  => 'ул',
                        },
                        {
                            formal_name => 'Екатеринбург',
                            guid        => '2763c110-cb8b-416a-9dac-ad28a55b4402',
                            obj_level   => 4,
                            parent_guid => '92b30014-4d52-4e2e-892d-928142b924bf',
                            short_name  => 'г',
                        },
                        {
                            formal_name => 'Свердловская',
                            guid        => '92b30014-4d52-4e2e-892d-928142b924bf',
                            obj_level   => 1,
                            parent_guid => undef,
                            short_name  => 'обл',
                        },
                    ],
                    result => 'ok',
                },
            ],
            'guid 0560cfb6-d931-4bb8-93f0-1889a5fc4a9a is in db',
        );

        cmp_deeply(
            [
                request_to_intapi(
                    app            => $app,
                    path           => $PATH_NAME,
                    method         => $METHOD_NAME,
                    request_method => 'GET',
                    content_type   => 'application/json',
                    query_string   => 'guid=asdf',
                    mode           => 'split_json_answer',
                )
            ],
            [
                "Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
                {
                    data   => [],
                    result => 'ok',
                },
            ],
            "guid asdf is not in db",
        );

    },
    application_package => 'IntAPI',
    init                => [qw(intapi_acl)],
    locale              => 'C',
);
