#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Deep;
use Test::Partner::Utils;
use Test::Partner2::Mock;

use qbit;

my $PATH_NAME        = 'form';
my $METHOD_NAME_HIDE = 'create_person';
my $METHOD_NAME_FULL = 'update_contract';

run_tests(
    sub {
        my ($app) = @_;

        require Exception::API::XMLRPC;

        mock_subs(
            {
                'QBit::Application::Model::API::XMLRPC::call' => sub {
                    throw Exception::API::XMLRPC '<error></error>';
                },
            }
        );

        my ($header, $body);
        ($header, $body) = request_to_intapi(
            app            => $app,
            path           => $PATH_NAME,
            method         => $METHOD_NAME_FULL,
            request_method => 'POST',
            content_type   => 'application/json',
            query_string   => '',
            mode           => 'split_json_answer',
            body           => to_json(
                {
                    operator_uid => 537165016,
                    contract_id  => 732013,
                    person_id    => 6841682,
                }
            ),
        );

        is(
            $header,
            "Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
            'got expected header'
          );
        is(
            XML::Twig->new()->parse($body->{data}{error_message})->root->first_child('opts')->trimmed_text,
            '[ 537165016, 732013, { "person_id" : 6841682 } ]',
            'got answer with data'
          );

        ($header, $body) = request_to_intapi(
            app            => $app,
            path           => $PATH_NAME,
            method         => $METHOD_NAME_HIDE,
            request_method => 'POST',
            content_type   => 'application/json',
            query_string   => '',
            mode           => 'split_json_answer',
            body           => to_json(
                {
                    client_id    => 123,
                    email        => 'aa@yandex.ru',
                    name         => 'name',
                    operator_uid => 123,
                    person_id    => -1,
                    postcode     => 'postcode',
                    type         => 'sw_yt',
                }
            ),
        );

        is(
            $header,
            "Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
            'got expected header'
          );
        is(XML::Twig->new()->parse($body->{data}{error_message})->root->first_child('opts')->trimmed_text,
            'XXX', 'got answer without data');
    },
    application_package => 'IntAPI',
    init                => [qw(api_balance intapi_acl)],
    locale              => 'C',
);
