#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::More;
use Test::Deep;

use qbit;

$ENV{LAZY_LOAD} = FALSE;

my $PATH_NAME   = 'form';
my $METHOD_NAME = 'list_attachments';

run_tests(
    sub {
        my ($app) = @_;

        my $mocked_prefix = 'prefix';
        my $mocked_list = [map {"${mocked_prefix}_$_"} (1, 2, 3)];

        {
            no strict 'refs';
            no warnings 'redefine';
            *IntAPI::Method::Form::PARTNER_FORM_S3_PREFIX = \$mocked_prefix;
            *{'Application::Model::API::Yandex::MediaStorage::S3::list'} = sub {
                my ($self, $prefix) = @_;
                is($prefix, "${mocked_prefix}_123_", 's3 list prefix');
                return $mocked_list;
            };
        }

        my ($header, $out) = request_to_intapi(
            app          => $app,
            path         => $PATH_NAME,
            method       => $METHOD_NAME,
            query_string => 'uid=123',
            mode         => 'only_stdout',
        );

        cmp_deeply(
            from_json($out),
            {
                'data'   => $mocked_list,
                'result' => 'ok'
            },
            'Data - ok'
        );
    },
    application_package  => 'IntAPI',
    dont_create_database => 1,
    init                 => [qw(intapi_acl)]
);
