#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Deep;
use Test::Partner::Utils;

use qbit;

my $PATH_NAME   = 'form';
my $METHOD_NAME = 'person';

run_tests(
    sub {
        my ($app) = @_;

        $app->api_balance;
        $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

        $app->api_balance->mock(
            'call',
            sub {
                my ($self, $method, $client_id, $type) = @_;

                is($method, 'Balance.GetClientPersons', 'running Balance.GetClientPersons');

                return [
                    [
                        {id => 123,},
                        {
                            id       => 6665795,
                            longname => 'Фамилия',
                            name     => 'Имя',
                            mname    => 'Отчество',
                            kpp      => '525601001',
                        },
                    ]
                ];

            }
        );

        cmp_deeply(
            [
                request_to_intapi(
                    app            => $app,
                    path           => $PATH_NAME,
                    method         => $METHOD_NAME,
                    request_method => 'GET',
                    content_type   => 'application/json',
                    query_string   => '',
                    mode           => 'split_json_answer',
                )
            ],
            [
"Status: 400 Bad request\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
                {
                    error_type => 'Exception::Validation::BadArguments',
                    message    => 'Отсутствует обязательный параметр "client_id"',
                    result     => 'error',
                },
            ],
            'error - must specify person_id',
        );

        cmp_deeply(
            [
                request_to_intapi(
                    app            => $app,
                    path           => $PATH_NAME,
                    method         => $METHOD_NAME,
                    request_method => 'GET',
                    content_type   => 'application/json',
                    query_string   => 'client_id=81592624&person_id=6665795',
                    mode           => 'split_json_answer',
                )
            ],
            [
                "Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
                {
                    data => {
                        id       => 6665795,
                        longname => 'Фамилия',
                        name     => 'Имя',
                        mname    => 'Отчество',
                        kpp      => '525601001',
                    },
                    result => 'ok',
                },
            ],
            'got expected data',
        );

    },
    application_package => 'IntAPI',
    init                => [qw(intapi_acl users rbac)],
    locale              => 'C',
);
