#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::More;
use Test::Deep;
use Test::MockObject::Extends;

use qbit;

my $PATH_NAME   = 'form';
my $METHOD_NAME = 'query_fias';

run_tests(
    sub {
        my ($app) = @_;

        $app->partner_db->fias->add_multi(
            [
                {
                    'obj_level'   => '1',
                    'guid'        => '1',
                    'parent_guid' => undef,
                    'formal_name' => 'REGION',
                    'short_name'  => ''
                },
                {
                    'obj_level'   => '4',
                    'guid'        => '2',
                    'parent_guid' => '1',
                    'formal_name' => 'CITY',
                    'short_name'  => ''
                },
                {
                    'obj_level'   => '7',
                    'guid'        => '5',
                    'parent_guid' => '2',
                    'formal_name' => 'STREET',
                    'short_name'  => ''
                }
            ]
        );

        my ($header, $out) = request_to_intapi(
            app    => $app,
            path   => $PATH_NAME,
            method => $METHOD_NAME,
            mode   => 'only_stdout',
        );

        is_deeply(
            from_json($out)->{data},
            [
                {
                    formal_name => "REGION",
                    guid        => 1,
                    obj_level   => 1,
                    short_name  => ""
                },
            ],
            'query regions'
        );

        ($header, $out) = request_to_intapi(
            app          => $app,
            path         => $PATH_NAME,
            method       => $METHOD_NAME,
            mode         => 'only_stdout',
            query_string => 'parent_guid=1',
        );

        is_deeply(
            from_json($out)->{data},
            [
                {
                    formal_name => "CITY",
                    guid        => 2,
                    obj_level   => 4,
                    short_name  => ""
                },
            ],
            'query by parent_guid'
        );
    },
    skip_init_user      => TRUE,
    application_package => 'IntAPI',
    fill_databases      => 0,
    init                => [qw(intapi_acl)]
);
