#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Deep;
use Test::Partner::Utils;

use qbit;

my $PATH_NAME   = 'form';
my $METHOD_NAME = 'remove_user_client_association';

sub invalid_params {
    my ($app) = @_;

    cmp_deeply(
        [
            request_to_intapi(
                app            => $app,
                path           => $PATH_NAME,
                method         => $METHOD_NAME,
                request_method => 'GET',
                content_type   => 'application/json',
                query_string   => '',
                mode           => 'split_json_answer',
            )
        ],
        [
            "Status: 400 Bad request\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
            {
                error_type => 'Exception::Validation::BadArguments',
                message    => 'Отсутствует обязательный параметр "client_id"',
                result     => 'error',
            },
        ],
        'error - must specify operator_user_id',
    );

    return 1;
}

sub standard_removal {
    my ($app) = @_;

    $app->api_balance->mock(
        'call',
        sub {
            my ($self, $method, $operator_user_id, $client_id, $user_id) = @_;

            is($method,           'Balance.RemoveUserClientAssociation', 'running Balance.RemoveUserClientAssociation');
            is($operator_user_id, 100,                                   'operator_user_id');
            is($client_id,        200,                                   'client_id');
            is($user_id,          300,                                   'user_id');

            return [0];
        }
    );

    cmp_deeply(
        [
            request_to_intapi(
                app            => $app,
                path           => $PATH_NAME,
                method         => $METHOD_NAME,
                request_method => 'GET',
                content_type   => 'application/json',
                query_string   => 'operator_user_id=100&client_id=200&user_id=300',
                mode           => 'split_json_answer',
            )
        ],
        [
            "Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
            {
                data   => 'ok',
                result => 'ok',
            },
        ],
        'successfull removal',
    );

    return 1;
}

sub not_linked {
    my ($app) = @_;

    $app->api_balance->mock(
        'call',
        sub {
            my ($self, $method, $operator_user_id, $client_id, $user_id) = @_;

            is($method,           'Balance.RemoveUserClientAssociation', 'running Balance.RemoveUserClientAssociation');
            is($operator_user_id, 123,                                   'operator_user_id');
            is($client_id,        123,                                   'client_id');
            is($user_id,          123,                                   'user_id');

            return ['4009', 'Passport anastasya (123) is NOT linked to client 123'];
        }
    );

    cmp_deeply(
        [
            request_to_intapi(
                app            => $app,
                path           => $PATH_NAME,
                method         => $METHOD_NAME,
                request_method => 'GET',
                content_type   => 'application/json',
                query_string   => 'operator_user_id=123&client_id=123&user_id=123',
                mode           => 'split_json_answer',
            )
        ],
        [
            "Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
            {
                data   => 'ok',
                result => 'ok',
            },
        ],
        'already removed',
    );

    return 1;
}

run_tests(
    sub {
        my ($app) = @_;

        $app->api_balance;
        $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

        invalid_params($app);
        standard_removal($app);
        not_linked($app);

    },
    application_package => 'IntAPI',
    init                => [qw(api_balance intapi_acl)],
    locale              => 'C',
);
