#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Partner::Utils;
use Test::Differences;
use Exception::Balance::NotFound;

use qbit;

run_tests(
    \&main_test,
    application_package => 'IntAPI',
    init                => [qw(api_balance intapi_acl)],
    locale              => 'C',
);

sub main_test {
    my ($app) = @_;

    $app->api_balance;
    $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

    my $test;
    $app->api_balance->mock(
        'call',
        sub {
            my ($self, $method, @opts) = @_;
            $test->{method} = $method;
            $test->{opts}   = \@opts;
            throw Exception::Balance::NotFound unless $test->{return};
            return $test->{return};
        }
    );

    my $file  = 'tests.json';
    my $tests = get_test_data_and_update_if_needed($file);

    for my $t (@$tests) {
        $test = $t;
        my ($header, $out) = request_to_intapi(
            app            => $app,
            path           => 'form',
            method         => 'rubank_account',
            request_method => 'GET',
            content_type   => 'application/json',
            query_string   => $test->{query},
            mode           => 'split_json_answer',
        );
        $test->{header} = [split /\n/, $header];
        $test->{out} = $out;
    }

    my $expected = get_test_data_and_update_if_needed($file, $tests);
    eq_or_diff($tests, $expected, 'check');
}
