#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::More;
use Test::Deep;

use qbit;

$ENV{LAZY_LOAD} = FALSE;

my $PATH_NAME   = 'form';
my $METHOD_NAME = 'save_attachment';

run_tests(
    sub {
        my ($app) = @_;

        my $mocked_key  = 'partner_form_123_OIULKJNL_43251';
        my $mocked_type = 'application/test';
        my $mocked_data = 'test_data';
        my $mocked_body = <<BODY;
--------------------------c1cb6b5a71b93044
Content-Disposition: form-data; name="data"; filename="mocked_filename"
Content-Type: $mocked_type

$mocked_data
--------------------------c1cb6b5a71b93044
Content-Disposition: form-data; name="uid"

123
--------------------------c1cb6b5a71b93044--
BODY

        {
            no strict 'refs';
            no warnings 'redefine';
            *IntAPI::Method::Form::_build_key = sub {
                return $mocked_key;
            };
            *{'Application::Model::API::Yandex::MediaStorage::S3::put'} = sub {
                my ($self, $key, $type, $scalar) = @_;
                is($key,    $mocked_key,  's3 put key');
                is($type,   $mocked_type, 's3 put type');
                is($scalar, $mocked_data, 's3 put data');
                return 1;
            };
        }

        my ($header, $out) = request_to_intapi(
            app            => $app,
            path           => $PATH_NAME,
            method         => $METHOD_NAME,
            request_method => 'POST',
            content_type   => 'multipart/form-data',
            body           => $mocked_body,
            mode           => 'only_stdout',
        );

        cmp_deeply(
            from_json($out),
            {
                'data'   => {'key' => 'partner_form_123_OIULKJNL_43251',},
                'result' => 'ok'
            },
            'Data - ok'
        );
    },
    application_package  => 'IntAPI',
    dont_create_database => 1,
    init                 => [qw(intapi_acl)]
);
