#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Deep;
use Test::Partner::Utils;

use qbit;

my $PATH_NAME   = 'form';
my $METHOD_NAME = 'save_data';

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate("2018-03-29 17:11:07");

        my ($header_1, $out_1) = request_to_intapi(
            app            => $app,
            path           => $PATH_NAME,
            method         => $METHOD_NAME,
            request_method => 'POST',
            content_type   => 'application/json',
            query_string   => '',
            mode           => 'only_stdout',
            body           => to_json(
                {
                    branch_id  => 'russia_ph',
                    client_id  => 456,
                    country_id => 225,
                    data       => {},
                    person_id  => 789,
                    # не указан user_id
                }
            ),
        );

        cmp_deeply(
            {header => $header_1,},
            {
                header =>
"Status: 400 Bad request\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
            },
            'incorrect body for save_data',
        );

        my ($header_2, $out_2) = request_to_intapi(
            app            => $app,
            path           => $PATH_NAME,
            method         => $METHOD_NAME,
            request_method => 'POST',
            content_type   => 'application/json',
            query_string   => '',
            mode           => 'only_stdout',
            body           => to_json(
                {
                    branch_id  => 'russia_ph',
                    client_id  => 456,
                    country_id => 225,
                    data       => {},
                    person_id  => 789,
                    user_id    => 123,
                }
            ),
        );

        cmp_deeply(
            {
                header => $header_2,
                data   => from_json($out_2)->{data},
            },
            {
                header =>
                  "Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
                data => 'ok',
            },
            'correct body for save_data',
        );

        cmp_deeply(
            $app->partner_db->form_data->get_all(),
            [
                {
                    branch_id  => '',
                    client_id  => 11009,
                    country_id => 225,
                    dt         => '1970-01-01 03:00:00',
                    data       => '{}',
                    id         => 1,
                    person_id  => undef,
                    user_id    => 1009,
                },
                {
                    branch_id  => '',
                    client_id  => 11012,
                    country_id => 225,
                    dt         => '1970-01-01 03:00:00',
                    data       => '{}',
                    id         => 2,
                    person_id  => undef,
                    user_id    => 1012,
                },
                {
                    branch_id  => '',
                    client_id  => 11016,
                    country_id => 225,
                    dt         => '1970-01-01 03:00:00',
                    data       => '{}',
                    id         => 3,
                    person_id  => undef,
                    user_id    => 1016,
                },
                {
                    branch_id  => 'russia_ph',
                    client_id  => 456,
                    country_id => 225,
                    dt         => '2018-03-29 17:11:07',
                    data       => '{}',
                    id         => 4,
                    person_id  => 789,
                    user_id    => 123,
                },
            ],
            'got expected data in the database',
        );

    },
    application_package => 'IntAPI',
    init                => [qw(intapi_acl)],
    locale              => 'C',
);
