#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Deep;
use Test::Partner::Utils;

use qbit;

my $PATH_NAME   = 'form';
my $METHOD_NAME = 'send_email';

run_tests(
    sub {
        my ($app) = @_;

        $app->mail_notification;
        $app->{'mail_notification'} = Test::MockObject::Extends->new($app->{'mail_notification'});
        $app->mail_notification->mock(
            'add',
            sub {
                my ($self, %opts) = @_;
                cmp_deeply(
                    \%opts,
                    {
                        type    => 12,
                        period  => undef,
                        user_id => 1,
                        opts    => {
                            subject => 'subject',
                            values  => {
                                message_body => 'body',
                                template     => 'template_id'
                            },
                            vars => {}
                        },
                    },
                    'check mail_notification candidate to add'
                );
            }
        );

        cmp_deeply(
            [
                request_to_intapi(
                    app            => $app,
                    path           => $PATH_NAME,
                    method         => $METHOD_NAME,
                    request_method => 'POST',
                    content_type   => 'application/json',
                    query_string   => '',
                    mode           => 'split_json_answer',
                    body           => to_json(
                        {
                            user_id   => 1,
                            subject   => 'subject',
                            body      => 'body',
                            transport => 'sender',
                            template  => 'template_id',
                            vars      => {}
                        }
                    ),
                )
            ],
            [
                "Status: 200 OK\n"
                  . "X-Content-Type-Options: nosniff\n"
                  . "Content-Type: application/json; charset=UTF-8",
                {
                    data   => 'ok',
                    result => 'ok'
                }
            ],
            'check IntAPI send_email response'
        );

    },
    application_package => 'IntAPI',
    init                => [qw(intapi_acl users rbac)],
    locale              => 'C',
);
