#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Deep;
use Test::Partner::Utils;

use qbit;

my $PATH_NAME   = 'form';
my $METHOD_NAME = 'update_contract';

run_tests(
    sub {
        my ($app) = @_;

        $app->api_balance;
        $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

        $app->api_balance->mock(
            'call',
            sub {
                my ($self, $method, $operator_uid, $contract_id, $opts) = @_;

                is($method,       'Balance2.UpdateContract', 'running Balance2.UpdateContract');
                is($operator_uid, 537165016,                 'expected operator_uid in Balance2.UpdateContract');
                is($contract_id,  732013,                    'expected contract_id in Balance2.UpdateContract');

                cmp_deeply(
                    $opts,
                    {
                        person_id => 6841682,
                    },

                    'expected data in Balance2.UpdateContract',
                );

                return [{EXTERNAL_ID => 'РС-64233-05/18', ID => 611822}];
            }
        );

        my ($header1, $out1) = request_to_intapi(
            app            => $app,
            path           => $PATH_NAME,
            method         => $METHOD_NAME,
            request_method => 'POST',
            content_type   => 'application/json',
            query_string   => '',
            mode           => 'only_stdout',
            body           => to_json(
                {
                    operator_uid => 537165016,
                    contract_id  => 732013,
                    person_id    => 6841682,
                }
            ),
        );

        is(
            $header1,
            "Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
            'got expected header'
          );
        is_deeply(
            from_json($out1)->{data},
            {contract => {EXTERNAL_ID => 'РС-64233-05/18', ID => 611822}},
            'got expected answer',
        );

        my ($header2, $out2) = request_to_intapi(
            app            => $app,
            path           => $PATH_NAME,
            method         => $METHOD_NAME,
            request_method => 'POST',
            content_type   => 'application/json',
            query_string   => '',
            mode           => 'split_json_answer',
            body           => 'not a valid json',
        );

        is(
            $header2,
            "Status: 400 Bad request\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
            'got expected header'
          );
        is_deeply(
            $out2,
            {
                error_type => 'Exception::Validation::BadArguments',
                message    => 'Body must be a valid json',
                result     => 'error',
            },
            'got expected answer',
        );

    },
    application_package => 'IntAPI',
    init                => [qw(api_balance intapi_acl)],
    locale              => 'C',
);
