#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Differences;
use Test::More;

use qbit;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed request_to_intapi);

my $PATH_NAME   = 'form';
my $METHOD_NAME = 'user';

my $FILE_NAME = 'data.json';

run_tests(
    sub {
        my ($app) = @_;

        {
            no strict 'refs';
            no warnings 'redefine';

            *{'Application::Model::Documents::get_raw_contracts'} = sub {
                my ($self, %opts) = @_;

                return [
                    {
                        'Person' => {},
                        'Client' => {
                            'overdraft_limit'        => '',
                            'reliable_cc_payer'      => '0',
                            'client_type_id'         => '0',
                            'email'                  => '',
                            'deny_cc'                => '0',
                            'region_id'              => '',
                            'url'                    => '',
                            'full_repayment'         => '1',
                            'id'                     => '82022449',
                            'aux_is_docs_separated'  => '0',
                            'manual_discount'        => '0',
                            'subregion_id'           => '',
                            'name'                   => 'Client',
                            'direct25'               => '0',
                            'manual_suspect'         => '0',
                            'manual_suspect_comment' => '',
                            'partner_type'           => '0',
                            'dt'                     => '2018-06-01',
                            'agency_id'              => '',
                            'is_non_resident'        => '0',
                            'iso_currency_payment'   => '',
                            'budget'                 => '0',
                            'domain_check_status'    => '0',
                            'city'                   => '',
                            'is_agency'              => '0',
                            'fax'                    => '',
                            'overdraft_ban'          => '0',
                            'internal'               => '0',
                            'suspect'                => '0',
                            'creation_dt'            => '2018-06-01',
                            'phone'                  => '',
                            'aux_is_docs_detailed'   => '0',
                            'currency_payment'       => '',
                            'domain_check_comment'   => '',
                            'fullname'               => '',
                            'class_id'               => '82022449',
                            'is_wholesaler'          => ''
                        },
                        'Collaterals' => [],
                        'Contract'    => {
                            'is_faxed'           => '',
                            'pay_to'             => '1',
                            'payment_type'       => '1',
                            'open_date'          => '0',
                            'collateral_type_id' => '',
                            'unilateral_acts'    => '0',
                            'id'                 => '896296',
                            'doc_set'            => '',
                            'person_id'          => '',
                            'external_id'        => "РС-66366-06/18",
                            'attribute_batch_id' => '534862',
                            'service_start_dt'   => '2018-06-01',
                            'print_tpl_barcode'  => '999999830446',
                            'market_api_pct'     => '50',
                            'type'               => 'PARTNERS',
                            'partner_pct'        => '43',
                            'num'                => '',
                            'search_forms'       => '0',
                            'is_cancelled'       => '',
                            'dt'                 => '2018-06-01',
                            'reward_type'        => '1',
                            'currency'           => '643',
                            'contract2_id'       => '719424',
                            'create_dt'          => '2018-06-01',
                            'contract_type'      => '9',
                            'firm'               => '1',
                            'client_id'          => '82022449',
                            'memo'               => "Договор создан автоматически",
                            'test_mode'          => '1',
                            'update_dt'          => '2018-06-01',
                            'is_signed'          => '',
                            'nds'                => '0'
                        }
                    }
                ];
            };

            *{'QBit::Application::Model::API::Yandex::Balance::get_client_id_by_uid'} = sub {
                my ($self, $uid) = @_;

                my %h = (
                    155209804 => 2901607,     # yndx-bessarabov uid => yndx-bessarabov client_id
                    607369863 => 44506419,    # BeS.teST-024 uid => mocked-yndx-adfox client_id
                );
                return $h{$uid};
            };
        }

        my @tests = (
            ['error - must specify user_id'                => ''],
            ['user has_role_in_partner2 = 1 without db'    => 'user_id=1009'],
            ['user has_role_in_partner2 = 1 with db'       => 'user_id=1009&db=1'],
            ["user has_role_in_partner2 = ''"              => 'user_id=20288211&db=1'],
            ["user has not client_id"                      => 'user_id=20288211&rep=1'],
            ["user has client_id linked with themself"     => 'user_id=155209804&rep=1'],
            ["user has client_id linked with someone else" => 'user_id=607369863&rep=1'],
        );

        my $data = get_test_data_and_update_if_needed($FILE_NAME);    # Just read
        my @new_data;
        for (@tests) {
            my ($test_name, $query) = @$_;
            push @new_data, [
                $test_name,
                request_to_intapi(
                    app            => $app,
                    path           => $PATH_NAME,
                    method         => $METHOD_NAME,
                    request_method => 'GET',
                    content_type   => 'application/json',
                    mode           => 'split_json_answer',

                    query_string => $query,
                )
            ];
            eq_or_diff($new_data[$#new_data], $data->[$#new_data], $test_name);
        }
        get_test_data_and_update_if_needed($FILE_NAME, \@new_data);

    },
    application_package => 'IntAPI',
    init                => [qw(api_balance documents intapi_acl rbac users)],
    locale              => 'C',
    do_not_die_on_fail  => need_self_update() ? 1 : 0,
);
