#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Data::Rmap qw(rmap_hash);
use Test::Differences;
use Test::More;

use PiConstants qw($TVM_HTTP_HEADER_NAME $IS_PRECISE);
use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Partner2::Mock qw(mock_subs);

use qbit;

my @result;

run_tests(
    sub {
        my ($app) = @_;

        my $tvm_idm = $app->get_option('tvm_idm');
        mock_subs(
            {
                'IntAPI::Method::get_tvm_source' => sub {
                    return $tvm_idm;
                },
            }
        );
        $app->partner_db->_do(
            "update `users` set `domain_login`=`login` where `domain_login` is null or `domain_login` = ''");

        make_request($app);

        my $has = get_test_data_and_update_if_needed('data.json', \@result);
        if ($IS_PRECISE) {
            my $fix_data_sub = sub {
                my ($el) = @_;
                my @fields_to_num = qw(page_id);
                map {$el->{$_} += 0} grep {defined $el->{$_}} @fields_to_num;
                return $el;
            };
            rmap_hash {$fix_data_sub->($_)} @result;
            rmap_hash {$fix_data_sub->($_)} @$has;
        }
        eq_or_diff(\@result, $has, 'body');

    },
    application_package => 'IntAPI',
    do_not_die_on_fail  => TRUE,
);

sub make_request {
    my ($app) = @_;

    my ($header, $body) = request_to_intapi(
        app          => $app,
        path         => 'idm',
        method       => 'get_all_roles',
        mode         => 'split_json_answer',
        body         => '',
        http_headers => {$TVM_HTTP_HEADER_NAME => 'valid_ticket'},
    );

    push @result, {header => [split /\n/, $header], body => $body};
}
