#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use PiConstants qw($TVM_HTTP_HEADER_NAME);
use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Differences;
use Test::More;

use Test::Partner2::Mock qw(mock_subs);

use qbit;

my @result;

run_tests(
    sub {
        my ($app) = @_;

        my $tvm_idm = $app->get_option('tvm_idm');
        mock_subs(
            {
                'IntAPI::Method::get_tvm_source' => sub {
                    return $tvm_idm;
                },
            }
        );

        make_request($app);

        my $has = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $has, 'body');

    },
    application_package => 'IntAPI',
    do_not_die_on_fail  => TRUE,
);

sub make_request {
    my ($app) = @_;

    my ($header, $body) = request_to_intapi(
        app          => $app,
        path         => 'idm',
        method       => 'info',
        mode         => 'split_json_answer',
        body         => '',
        http_headers => {$TVM_HTTP_HEADER_NAME => 'valid_ticket'},
    );

    push @result, {headers => [split /\n/, $header], body => $body};
}
