#!/usr/bin/perl -w

use Test::Most;
use Test::Deep qw(
  bag
  cmp_deeply
  );

use qbit;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(request_to_intapi);

my $PATH_NAME   = 'metrika';
my $METHOD_NAME = 'mobile_page_ids';

run_tests(
    sub {
        my ($app) = @_;

        my ($stdout, $stderr, $exit_status) = request_to_intapi(
            app          => $app,
            path         => $PATH_NAME,
            method       => $METHOD_NAME,
            query_string => 'pretty=1',
            mode         => 'split_answer',
        );

        ok($exit_status, 'exit status');

        is($stderr, '', 'stderr');

        my ($header, $body) = split("\n\n", $stdout);

        is($header, "Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
            'stderr');

        cmp_deeply(
            from_json($body),
            {
                data => {
                    data => bag(
                        {
                            # internal_mobile_app
                            PageID => 132439,
                        },
                        {
                            # ssp_mobile_app
                            PageID => 155561,
                        },
                        {
                            # mobile_app_settings - 'test'
                            PageID => 43569,
                        },
                        {
                            # mobile_app_settings - Дефолтный пейдж рубикона'
                            PageID => 153979,
                        },
                        {
                            # mobile_app_settings
                            PageID => 153980,
                        },
                        {
                            # mobile_app_settings - 'Smaato/Заглушечная'
                            PageID => 154198,
                        },
                        {
                            # mobile_app_settings - tutby
                            PageID => 213953
                        },
                    ),
                    fields => [
                        'PageID',
                    ],
                    options => {
                        without_headers => 1,
                        end_marker      => FALSE,
                    },
                },
                result => 'ok'
            },
        );
    },
    application_package => 'IntAPI',
    init                => [qw(intapi_acl)],
);
