#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Differences qw(eq_or_diff);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use qbit;

use PiConstants qw(
  $DRIVE2_USER_ID
  $GOMAILRU_ADS_USER_ID
  $M_RU_TEXT_USER_ID
  $RAMBLER_P_USER_ID
  $TUTBYSEARCH_USER_ID
  );

my $PATH_NAME   = 'search_xml';
my $METHOD_NAME = 'camp_report';

run_tests(
    sub {
        my ($app) = @_;

        my $methods = $app->get_methods();

        my $api = $methods->{$PATH_NAME}{$METHOD_NAME}{'package'}->new(
            app   => $app,
            path  => $PATH_NAME,
            attrs => $methods->{$PATH_NAME}{$METHOD_NAME}->{'attrs'}
        );

        # PI-10225
        $app->partner_db->search_on_site_campaign->edit(
            111161,
            {
                yandex_xml => 1,
                multistate =>
                  $app->search_on_site_campaign->get_multistates_by_filter('working and balance_registered')->[0],
                owner_id => $RAMBLER_P_USER_ID,
            }
        );

        $app->partner_db->search_on_site_campaign->edit(
            803,
            {
                yandex_xml => 1,
                multistate =>
                  $app->search_on_site_campaign->get_multistates_by_filter('working and balance_registered')->[0],
                owner_id => $M_RU_TEXT_USER_ID,
            }
        );

        # PI-15060
        $app->partner_db->search_on_site_campaign->edit(
            804,
            {
                yandex_xml => 1,
                multistate =>
                  $app->search_on_site_campaign->get_multistates_by_filter('working and balance_registered')->[0],
                owner_id => $DRIVE2_USER_ID,
            }
        );

        # PI-17452
        $app->partner_db->search_on_site_campaign->edit(
            805,
            {
                yandex_xml => 1,
                multistate =>
                  $app->search_on_site_campaign->get_multistates_by_filter('working and balance_registered')->[0],
                owner_id => $TUTBYSEARCH_USER_ID,
            }
        );

        my $data = $methods->{$PATH_NAME}{$METHOD_NAME}{'sub'}->($api);

        my $expected = get_test_data_and_update_if_needed('data.json', $data);
        eq_or_diff(from_json(to_json($data)), $expected, 'check response', {context => 10});
    },
    application_package => 'IntAPI'
);
