#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Most;
use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);
use Test::Partner::Utils;
use Test::Deep;

use qbit;

#TODO: fix this test after PI-13812

run_tests(
    sub {
        my ($app) = @_;

        my @GET_STATISTICS2_PARAMS = ();
        mock_subs(
            {
                'Application::Model::BKStatistics::get_statistics2' => sub {
                    my ($self, %opts) = @_;

                    push(@GET_STATISTICS2_PARAMS, to_json(\%opts, canonical => 1));
                    return $app->bk_statistics->_get_empty_get_statistics2_answer(%opts);
                },
            }
        );

        my ($header, $out) = request_to_intapi(
            app          => $app,
            path         => 'statface',
            method       => 'money_by_products',
            query_string => 'lang=ru&from=2017-01-03&to=2017-01-03',
            mode         => 'only_stdout',
        );

        my %expected =
          map {$_ => []}
          qw(advnet_context_on_site_adblock advnet_context_on_site_content advnet_context_on_site_direct advnet_context_on_site_market advnet_context_on_site_market_api advnet_context_on_site_mcb advnet_context_on_site_natural advnet_context_on_site_rtb advnet_context_on_site_stripe advnet_search_on_site_direct advnet_search_on_site_market advnet_search_on_site_market_api advnet_search_on_site_mcb advnet_search_on_site_premium indoor_block internal_advnet_context_on_site_content internal_advnet_context_on_site_direct internal_advnet_context_on_site_natural internal_advnet_context_on_site_rtb internal_advnet_context_on_site_stripe internal_advnet_search_on_site_direct internal_advnet_search_on_site_premium internal_mobile_app_rtb mobile_app_rtb outdoor_block ssp_context_rtb_rtb ssp_mobile_app_rtb ssp_video_app_rtb video_an_site_fullscreen video_an_site_inpage video_an_site_instream);

        cmp_deeply(from_json($out)->{'data'}, \%expected, 'check empty response');

        my $file_path = lib::abs::path(".") . "/data/statface_money_by_products.sql";
        my $expected_sql = readfile($file_path) // '';

        if (need_self_update()) {
            writefile($file_path, join("\n\n", @GET_STATISTICS2_PARAMS) . "\n");
            fail 'SELF_UPDATE';
        } else {
            eq_or_diff(join("\n\n", @GET_STATISTICS2_PARAMS) . "\n", $expected_sql, "check requests", {context => 0});
        }
    },
    application_package => 'IntAPI',
    init                => [qw(intapi_acl bk_statistics)],
);
