#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Data::Rmap qw(rmap_hash);
use Test::Differences;
use Test::More;

use PiConstants qw($IS_PRECISE);
use Test::Partner2::Simple;
use Test::Partner::Utils;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        _mock_call(to_json({src => $app->get_option('tvm_app_takeout')}));

        my @got = (
            make_request($app, 337625302, 1234567890),    # exists user
            make_request($app, 1011,      1234567890),    # exists user
            make_request($app, 1009,      1234567890),    # exists user
            make_request($app, 1,         1234567890),    # not exists user
        );

        my $has = get_test_data_and_update_if_needed('data.json', \@got);
        if ($IS_PRECISE) {
            my $fix_data_sub = sub {
                my ($el) = @_;
                my @fields_to_num = qw(country_id);
                foreach my $key (qw( pi_user.json )) {
                    if (defined $el->{$key}) {
                        foreach my $subkey (@fields_to_num) {
                            $el->{$key} =~ s/("$subkey":)"(\d+)"/$1$2/g;
                        }
                    }
                }
                return $el;
            };
            rmap_hash {$fix_data_sub->($_)} @got;
            rmap_hash {$fix_data_sub->($_)} @$has;
        }
        eq_or_diff(\@got, $has, 'body');

    },
    application_package => 'IntAPI',
    init                => [qw(intapi_acl api_tvm)],
    do_not_die_on_fail  => TRUE,
);

sub make_request {
    my ($app, $uid, $ut) = @_;

    my ($header, $got) = request_to_intapi(
        app            => $app,
        path           => 'takeout',
        method         => 'takeout',
        request_method => "POST",
        mode           => 'split_json_answer',
        query_string   => "uid=$uid&unixtime=$ut",
        body           => '',
        http_headers   => {'X-Ya-Service-Ticket' => '998877'},
    );

    is(
        $header,
        "Status: 200 OK\nX-Content-Type-Options: nosniff\nContent-Type: application/json; charset=UTF-8",
        'header ' . $uid
      );

    return $got;
}

sub _mock_call {
    my ($data) = @_;

    no warnings 'redefine';
    no warnings 'once';
    no strict 'refs';
    *Application::Model::API::Yandex::TVM::call_command = sub {
        return $data;
    };
}
