#!/usr/bin/perl -w

use Test::Most;
use Test::Partner2::Simple;
use Test::Differences;

use qbit;

my $PATH_NAME   = 'yacotools';
my $METHOD_NAME = 'domains_report';

run_tests(
    sub {
        my ($app) = @_;

        my $methods = $app->get_methods();

        my $api = $methods->{$PATH_NAME}{$METHOD_NAME}{'package'}->new(
            app   => $app,
            path  => $PATH_NAME,
            attrs => $methods->{$PATH_NAME}{$METHOD_NAME}->{'attrs'}
        );

        my $data = $methods->{$PATH_NAME}{$METHOD_NAME}{'sub'}->($api);

        eq_or_diff(
            [sort {$a->{'page_id'} <=> $b->{'page_id'} || $a->{'domains'} cmp $b->{'domains'}} @{$data->{'data'}}],
            [
                {
                    'domains' => 'indoor.ya',
                    'page_id' => 40
                },
                {
                    'domains' => 'indoor.ya',
                    'page_id' => 41
                },
                {
                    'domains' => 'indoor.ya',
                    'page_id' => 47
                },
                {
                    'domains' => 'outdoor.ya',
                    'page_id' => 400
                },
                {
                    'domains' => 'outdoor.ya',
                    'page_id' => 470
                },
                {
                    'domains' => 'showmethemoney.ru',
                    'page_id' => 799
                },
                {
                    'domains' => 'protected.com',
                    'page_id' => 801
                },
                {
                    'domains' => 'protected.com',
                    'page_id' => 802
                },
                {
                    'domains' => 'protected.com',
                    'page_id' => 804
                },
                {
                    'domains' => 'showmethemoney.ru,approvedmirror.ru,newmirror.ru',
                    'page_id' => 41443
                },
                {
                    'domains' => 'app.test.com',
                    'page_id' => 43569
                },
                {
                    'domains' => 'com.yandex',
                    'page_id' => 132439
                },
                {
                    'domains' => 'xn--80apaahia1b8c.xn--p1ai',
                    'page_id' => 148805
                },
                {
                    'domains' => 'showmethemoney.ru',
                    'page_id' => 153744
                },
                {
                    'domains' => 'example.com',
                    'page_id' => 153745
                },
                {
                    'domains' => 'dsp.yandex.ru',
                    'page_id' => 153979
                },
                {
                    'domains' => 'test.com',
                    'page_id' => 153980
                },
                {
                    'domains' => 'dsp.yandex.ru',
                    'page_id' => 154198
                },
                {
                    'domains' => 'newsru.com,approvedmirror.ru',
                    'page_id' => 154689
                },
                {
                    'domains' => 'ladyeve.ru',
                    'page_id' => 154690
                },
                {
                    'domains' => 'test.ssp.bundleId',
                    'page_id' => 155561
                },
                {
                    'domains' => 'app.test.com',
                    'page_id' => 213953
                },
                {
                    'domains' => 'example.com',
                    'page_id' => 444190,
                },
                {
                    'domains' => 'example.com',
                    'page_id' => 509536,
                },
            ],
            'check response data'
        );
        delete $data->{'data'};
        eq_or_diff(
            $data,
            {
                'fields'       => ['page_id', 'domains'],
                'with_headers' => 1
            },
            'check response meta'
        );
    },
    application_package => 'IntAPI'
);
