#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Data::Rmap qw(rmap_hash);
use PiConstants qw($TVM_HTTP_HEADER_NAME $IS_PRECISE);
use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Differences;
use Test::More;

use qbit;

my @result;

run_tests(
    sub {
        my ($app) = @_;

        my @got;

        _mock_call(to_json({src => $app->get_option('tvm_app_takeout')}));
        make_request($app, 337625302, 1234567890, 'ticket1');

        _mock_call(to_json({src => 'ticket_with_invalid_source'}));
        make_request($app, 337625302, 1234567890, 'ticket2');

        make_request($app, 337625302, 1234567890);

        my $has = get_test_data_and_update_if_needed('data.json', \@result);
        if ($IS_PRECISE) {
            my $fix_data_sub = sub {
                my ($el) = @_;
                my @fields_to_num = qw(country_id);
                foreach my $key (qw( pi_user.json )) {
                    if (defined $el->{$key}) {
                        foreach my $subkey (@fields_to_num) {
                            $el->{$key} =~ s/("$subkey":)"(\d+)"/$1$2/g;
                        }
                    }
                }
                return $el;
            };
            rmap_hash {$fix_data_sub->($_)} @result;
            rmap_hash {$fix_data_sub->($_)} @$has;
        }
        eq_or_diff(\@result, $has, 'body');

    },
    application_package => 'IntAPI',
    init                => [qw(intapi_acl api_tvm)],
    do_not_die_on_fail  => TRUE,
);

sub make_request {
    my ($app, $uid, $ut, $ticket) = @_;

    my ($header, $body) = request_to_intapi(
        app            => $app,
        path           => 'takeout',
        method         => 'takeout',
        request_method => "POST",
        mode           => 'split_json_answer',
        query_string   => "uid=$uid&unixtime=$ut",
        body           => '',
        ($ticket ? (http_headers => {$TVM_HTTP_HEADER_NAME => $ticket}) : ()),
    );

    push @result, [$header, $body];
}

sub _mock_call {
    my ($data) = @_;

    no warnings 'redefine';
    no warnings 'once';
    no strict 'refs';
    *Application::Model::API::Yandex::TVM::call_command = sub {
        return $data;
    };
}
