#!/usr/bin/perl -w

use Test::Partner2::Simple;

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Utils qw($SKIP_MODELS);

use Test::More tests => 128;
use Test::Deep;

use qbit;

use Partner::BlockPreset::Component::Strategies;

my $FIXTURES = [
    {
        name       => 'minimal_cpm',
        strategies => {
            strategy      => 0,
            mincpm        => 10,
            text_active   => undef,
            text_blocked  => undef,
            text_cpm      => undef,
            media_active  => undef,
            media_blocked => undef,
            media_cpm     => undef,
        },
    },
    {
        name       => 'max_revenue',
        strategies => {
            strategy      => 1,
            mincpm        => undef,
            text_active   => undef,
            text_blocked  => undef,
            text_cpm      => undef,
            media_active  => undef,
            media_blocked => undef,
            media_cpm     => undef,
        },
    },
    {
        name       => 'text_blocked',
        strategies => {
            strategy      => 3,
            mincpm        => undef,
            text_active   => 1,
            text_blocked  => 1,
            text_cpm      => undef,
            media_active  => undef,
            media_blocked => undef,
            media_cpm     => undef,
        },
    },
    {
        name       => 'text_cpm',
        strategies => {
            strategy      => 3,
            mincpm        => undef,
            text_active   => 1,
            text_blocked  => 0,
            text_cpm      => 10,
            media_active  => undef,
            media_blocked => undef,
            media_cpm     => undef,
        },
    },
    {
        name       => 'media_blocked',
        strategies => {
            strategy      => 3,
            mincpm        => undef,
            text_active   => undef,
            text_blocked  => undef,
            text_cpm      => undef,
            media_active  => 1,
            media_blocked => 1,
            media_cpm     => undef,
        },
    },
    {
        name       => 'media_cpm',
        strategies => {
            strategy      => 3,
            mincpm        => undef,
            text_active   => undef,
            text_blocked  => undef,
            text_cpm      => undef,
            media_active  => 1,
            media_blocked => 0,
            media_cpm     => 10,
        },
    },
];

run_tests(
    sub {
        my ($app) = @_;

        my $block_models = $app->product_manager->get_block_model_names();

        foreach my $block_model (@$block_models) {
            next if $SKIP_MODELS->{$block_model};

            foreach my $test (@$FIXTURES) {
                my $component = Partner::BlockPreset::Component::Strategies->new(settings => $test->{'strategies'});

                my $got_data = {filter => $component->get_filter($app->$block_model)};

                my $has_data = get_test_data_and_update_if_needed("$block_model/$test->{'name'}.json", $got_data);
                cmp_deeply($got_data, $has_data, "model: $block_model, strategy: $test->{'name'}");
            }
        }
    },
    do_not_die_on_fail => 1,
);
