#!/usr/bin/perl -w

use Test::Partner2::Simple;

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Utils qw($SKIP_MODELS);

use Test::More tests => 44;
use Test::Deep;

use qbit;

use Partner::BlockPreset;

my @LOGINS = qw(mocked-yan-partner mocked-yan-partner-assistant);

run_tests(
    sub {
        my ($app) = @_;

        my $preset = Partner::BlockPreset->new(settings => {});

        my $block_models = $app->product_manager->get_block_model_names();

        foreach my $login (@LOGINS) {
            change_cur_user($app, $login);

            foreach my $block_model (@$block_models) {
                next if $SKIP_MODELS->{$block_model};

                my $got_data = $preset->get_filter($app->$block_model);

                my $has_data = get_test_data_and_update_if_needed("$login/$block_model.json", $got_data);
                cmp_deeply($got_data, $has_data, "login: $login, model: $block_model");
            }
        }
    },
    do_not_die_on_fail => 1,
);
