#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::Deep;
use Test::Partner2::Simple;

require QBit::Application::Model::API::HTTP;

#use File::Slurp;

run_tests(
    sub {
        my ($app) = @_;

        my $common = {':content_file' => '/tmp/foo.tsv',};

        my $got = QBit::Application::Model::API::HTTP::_get_params_and_headers(
            $app,
            ':content_type' => 'application/json',
            'Foo'           => 'bar',
            %$common
        );

        my $expect = {
            'Content-type' => 'application/json',
            %$common
        };

        cmp_deeply($got, $expect, "_get_params_and_headers");

    },
    dont_create_database => 1,
);
