#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Log::Log4perl qw(get_logger :levels);
use Test::Exception;
use File::Slurp qw(write_file);
use File::Temp qw(tempfile);

use qbit;
use Test::Partner2::Simple;
use Test::More tests => 5;
require QBit::Application::Model::API::HTTP;

my $fixture = {
    'scalar content with marker' => {
        uri    => 'http://scalar.content.with.marker',
        params => {':get' => 1},
        throws => 0,
    },
    'scalar content without marker' => {
        uri    => 'http://scalar.content.without.marker',
        params => {':get' => 1},
        throws => 1,
    },
    'file content with marker' => {
        uri    => 'http://file.content.with.marker',
        params => {':get' => 1, ':content_file' => (tempfile(OPEN => 0))[1]},
        throws => 0,
    },
    'file content without marker' => {
        uri    => 'http://file.content.without.marker',
        params => {':get' => 1, ':content_file' => (tempfile(OPEN => 0))[1]},
        throws => 1,
    },
};

run_tests(
    sub {
        my ($app) = @_;

        # Убираем вывод DEBUG
        my $logger = Log::Log4perl->get_logger('')->level($ERROR);
        my $file_path;

        {
            no warnings 'redefine';
            no strict 'refs';

            *{'LWP::UserAgent::request'} = sub {
                my ($mock, $request) = @_;

                my $content;
                if ($request->uri =~ m/with\.marker/) {
                    $content = "mocked_data\n#END\n";
                } else {
                    $content = "mocked_data\n";
                }

                if ($file_path) {
                    write_file($file_path, $content);
                    $content = '';
                }

                my $r = HTTP::Response->new(200);
                $r->request($request);
                $r->content($content);
                return $r;
            };
        }

        my $self = $app->api_adfox;
        foreach my $testname (sort keys %$fixture) {
            my $test_data = $fixture->{$testname};

            $file_path = $test_data->{params}{':content_file'};

            if ($test_data->{throws}) {
                throws_ok {
                    QBit::Application::Model::API::HTTP::get(
                        $self, $test_data->{uri},
                        %{$test_data->{params}},
                        ':expected_end_marker' => "#END\n"
                    );
                }
                'Exception::API::HTTP', $testname;
            } else {
                lives_ok {
                    QBit::Application::Model::API::HTTP::get(
                        $self, $test_data->{uri},
                        %{$test_data->{params}},
                        ':expected_end_marker' => "#END\n"
                    );
                }
                $testname;
            }
        }
    },
    dont_create_database => 1,
);
