use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Differences;
use Test::More;

my $test_data = {
    create_dt        => '1234-56-78T99:00:00',
    dt               => '1234-56-78 99:00:00',
    end_dt           => '1234-56-78 99:00:00',
    is_cancelled     => '1234-56-78T99:00:00',
    is_faxed         => '1234-56-78 99:00:00',
    is_signed        => '1234-56-78T99:00:00',
    service_start_dt => '1234-56-78 99:00:00',
    start_dt         => '1234-56-78T99:00:00',
    update_dt        => '1234-56-78 99:00:00',
    some_extra_field => '1234-56-78T99:00:00',
};

my $expected_data = {
    create_dt        => '1234-56-78',
    dt               => '1234-56-78',
    end_dt           => '1234-56-78',
    is_cancelled     => '1234-56-78',
    is_faxed         => '1234-56-78',
    is_signed        => '1234-56-78',
    service_start_dt => '1234-56-78',
    start_dt         => '1234-56-78',
    update_dt        => '1234-56-78',
    some_extra_field => '1234-56-78T99:00:00',
};

run_tests(
    sub {
        my ($app) = @_;

        $app->api_balance->_fix_dates($test_data);

        eq_or_diff($test_data, $expected_data, 'correct date fixes');
    },
    dont_create_database => 1,
    fill_databases       => 0,
    init                 => [qw(api_balance)],
);
