#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Partner::Utils;
use Test::Differences;
use Exception::Balance::NotFound;

use qbit;

run_tests(\&main_test, init => [qw(api_balance)],);

sub main_test {
    my ($app) = @_;

    $app->api_balance;
    $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

    my $test;
    $app->api_balance->mock(
        'call',
        sub {
            my ($self, $method, @opts) = @_;
            $test->{method} = $method;
            $test->{opts}   = \@opts;
            throw Exception::Balance::NotFound unless $test->{return};
            return $test->{return};
        }
    );

    my $file  = 'tests.json';
    my $tests = get_test_data_and_update_if_needed($file);

    for my $t (@$tests) {
        $test = $t;
        try {
            my $data = $app->api_balance->check_rubank_account(%{$test->{params}});
            $test->{out} = $data;
        }
        catch {
            my ($e) = @_;
            $test->{exception} = ref $e;
        }
    }

    my $expected = get_test_data_and_update_if_needed($file, $tests);
    eq_or_diff($tests, $expected, 'check');
}
