use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils;    # qw(get_test_data_and_update_if_needed);

use Test::More;
use Test::Deep;

run_tests(
    sub {
        my ($app) = @_;

        $app->api_balance;
        $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

        $app->api_balance->mock(
            'call',
            sub {
                my ($self, $method, $opts) = @_;

                is($method, 'Balance.GetPartnerContracts', 'running Balance.GetPartnerContracts');

                cmp_deeply($opts, {ClientID => '1010004',}, 'got expected params',);
                return get_test_data_and_update_if_needed('get_partner_contracts_raw.json');
            }
        );

        my $data = $app->api_balance->get_partner_contracts(ClientID => '1010004',);

        is_deeply(
            $data,
            get_test_data_and_update_if_needed('get_partner_contracts.json', $data),
            'got expected answer',
        );
    },
);
``
