use strict;
use warnings FATAL => 'all';

use Test::Differences;
use Test::More tests => 2 + 5;

use Test::Partner2::Mock qw(mock_curdate);
use Test::Partner2::Simple;
use qbit;

my $MOCK_TIME = '2019-11-06 15:26:49';

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate($MOCK_TIME);

        eq_or_diff(
            $app->api_http_bk->_prepare_dsp_object_for_logbroker(
                {
                    disabled      => 1,
                    dsp_types     => 5,
                    id            => 2563166,
                    postmoderated => 0,
                    short_caption => 'thecaption',
                    tag           => 'somebstag',
                    url           => 'http://example.com/url',
                    use_pnocsy    => 0,
                }
            ),
            {
                DSPID => 2563166,
                Data  => to_json(
                    {
                        DSPTag          => 'somebstag',
                        DSPType         => 5,
                        Options         => 'disabled',
                        ShowProbability => 0,
                        Title           => 'thecaption',
                        Url             => 'http://example.com/url'
                    },
                    canonical => TRUE
                ),
                UnixTime => time,
            },
            'data with some options'
        );

        eq_or_diff(
            $app->api_http_bk->_prepare_dsp_object_for_logbroker(
                {
                    disabled                => 1,
                    dsp_types               => 5,
                    id                      => 2563166,
                    postmoderated           => 1,
                    short_caption           => 'thecaption',
                    skipnoud                => 1,
                    tag                     => 'somebstag',
                    unmoderated_rtb_auction => 1,
                    url                     => 'http://example.com/url',
                    use_pnocsy              => 1,
                }
            ),
            {
                DSPID => 2563166,
                Data  => to_json(
                    {
                        DSPTag          => 'somebstag',
                        DSPType         => 5,
                        Options         => 'disabled,postmoderated,skipnoud,unmoderated-rtb-auction,use-pnocsy',
                        ShowProbability => 0,
                        Title           => 'thecaption',
                        Url             => 'http://example.com/url'
                    },
                    canonical => TRUE
                ),
                UnixTime => time,
            },
            'data with full list of options'
        );

        eq_or_diff(
            $app->api_http_bk->_prepare_dsp_object_for_logbroker(
                {
                    disabled      => 1,
                    display_name  => 'DSP name',
                    dsp_types     => 5,
                    id            => 2563166,
                    postmoderated => 0,
                    short_caption => 'thecaption',
                    tag           => 'somebstag',
                    url           => 'http://example.com/url',
                    use_pnocsy    => 0,
                }
            ),
            {
                DSPID => 2563166,
                Data  => to_json(
                    {
                        DSPTag          => 'somebstag',
                        DSPType         => 5,
                        Options         => 'disabled',
                        ShowProbability => 0,
                        Title           => 'thecaption',
                        Url             => 'http://example.com/url'
                    },
                    canonical => TRUE
                ),
                UnixTime => time,
            },
            'data with display_name without patch'
        );

        eq_or_diff(
            $app->api_http_bk->_prepare_dsp_object_for_logbroker(
                {
                    disabled      => 1,
                    display_name  => 'DSP name',
                    dsp_types     => 5,
                    id            => 2563166,
                    patch         => to_json({'Options.show-public-title' => 1,}),
                    postmoderated => 0,
                    short_caption => 'thecaption',
                    tag           => 'somebstag',
                    url           => 'http://example.com/url',
                    use_pnocsy    => 0,
                }
            ),
            {
                DSPID => 2563166,
                Data  => to_json(
                    {
                        DSPTag          => 'somebstag',
                        DSPType         => 5,
                        Options         => 'disabled,show-public-title',
                        PublicTitle     => 'DSP name',
                        ShowProbability => 0,
                        Title           => 'thecaption',
                        Url             => 'http://example.com/url'
                    },
                    canonical => TRUE
                ),
                UnixTime => time,
            },
            'data with display_name with patch on Options'
        );

        eq_or_diff(
            $app->api_http_bk->_prepare_dsp_object_for_logbroker(
                {
                    disabled  => 1,
                    dsp_types => 5,
                    id        => 2563166,
                    patch     => to_json(
                        {
                            '__DEL__'            => ['Options.skipnoud', 'Url',],
                            'Options.use-pnocsy' => 0,
                        }
                    ),
                    postmoderated           => 1,
                    short_caption           => 'thecaption',
                    skipnoud                => 1,
                    tag                     => 'somebstag',
                    unmoderated_rtb_auction => 1,
                    url                     => 'http://example.com/url',
                    use_pnocsy              => 1,
                }
            ),
            {
                DSPID => 2563166,
                Data  => to_json(
                    {
                        DSPTag          => 'somebstag',
                        DSPType         => 5,
                        Options         => 'disabled,postmoderated,unmoderated-rtb-auction',
                        ShowProbability => 0,
                        Title           => 'thecaption',
                    },
                    canonical => TRUE
                ),
                UnixTime => time,
            },
            'data with full list of options but with patch correction'
        );
    },
    init => [qw(api_http_bk)],
);
