use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;
use Test::Exception;
use URI;

sub add_correct_dsp {
    my ($app) = @_;

    no warnings 'redefine';
    no strict 'refs';

    *{'LWP::UserAgent::request'} = sub {
        my ($mock, $request) = @_;
        my $url = $request->uri;

        cmp_deeply(
            {URI->new($url)->query_form()},
            {
                disabled      => 1,
                dsp_id        => 2563166,
                dsp_tag       => "somebstag",
                dsp_type      => 5,
                func          => "add_dsp",
                postmoderated => 0,
                'use-pnocsy'  => 1,
                testurl       => "",
                url           => "http://example.com/url",
                caption       => 'some caption',
            }
        );

        my $r = HTTP::Response->new(200);
        $r->request(HTTP::Request->new());
        $r->content('{"data_key":"ca13608dbd6962bcb1edbbe5b412e379","code":0}',);
        return $r;
    };

    my $data = $app->api_http_bk->add_dsp(
        disabled      => 1,
        dsp_types     => [0, 2,],
        id            => 2563166,
        postmoderated => 0,
        tag           => "somebstag",
        use_pnocsy    => 1,
        test_url      => "",
        url           => "http://example.com/url",
        short_caption => 'some caption',
    );

    cmp_deeply(
        $data,
        {
            data_key => 'ca13608dbd6962bcb1edbbe5b412e379',
            code     => 0,
        },
    );

    return 1;
}

sub add_dsp_with_bk_error {
    my ($app) = @_;

    no warnings 'redefine';
    no strict 'refs';

    *{'LWP::UserAgent::request'} = sub {
        my ($mock, $request) = @_;
        my $url = $request->uri;

        cmp_deeply(
            {URI->new($url)->query_form()},
            {
                disabled      => 1,
                dsp_id        => 2563166,
                dsp_tag       => "somebstag",
                dsp_type      => 5,
                func          => "add_dsp",
                'use-pnocsy'  => 1,
                postmoderated => 0,
                testurl       => "",
                url           => "http://example.com/url",
                caption       => 'c',
            },
        );

        my $r = HTTP::Response->new(200);
        $r->request(HTTP::Request->new());
        $r->content(q({"error":"DSP with DSPID = '2563166' already exists","code":1}),);
        return $r;
    };

    throws_ok(
        sub {
            my $data = $app->api_http_bk->add_dsp(
                disabled      => 1,
                dsp_types     => [0, 2,],
                id            => 2563166,
                postmoderated => 0,
                tag           => "somebstag",
                use_pnocsy    => 1,
                test_url      => "",
                url           => "http://example.com/url",
                short_caption => 'c',
            );

        },
        'Exception::BK',
    );

    return 1;
}

sub add_dsp_with_validation_error {
    my ($app) = @_;

    no warnings 'redefine';
    no strict 'refs';

    *{'LWP::UserAgent::request'} = sub {
        die 'this code should not be run';
    };

    throws_ok(
        sub {
            my $data = $app->api_http_bk->add_dsp(id => 'not a valid id',);

        },
        'Exception::Validator::Errors',
    );

    return 1;
}

sub add_dsp_while_option_is_turned_off {
    my ($app) = @_;

    no warnings 'redefine';
    no strict 'refs';

    *{'LWP::UserAgent::request'} = sub {
        fail 'call-method is called';
    };

    $app->api_http_bk->set_option('allow_dsp_via_http', 0);

    cmp_deeply($app->api_http_bk->add_dsp(), '', 'turn off dsp via http');

    return 1;
}

run_tests(
    sub {
        my ($app) = @_;

        $app->api_http_bk->set_option('allow_dsp_via_http', 1);

        add_correct_dsp($app);
        add_dsp_with_bk_error($app);
        add_dsp_with_validation_error($app);
        add_dsp_while_option_is_turned_off($app);
    },
    init => [qw(api_http_bk)],
);
