use strict;
use warnings FATAL => 'all';

use Test::Differences;
use Test::Exception;
use Test::More tests => 2 + 3;

use Test::Partner2::Mock qw(mock_subs restore_subs);
use Test::Partner2::Simple;

my $app;

sub correct_dsp {
    plan tests => 4;

    no warnings 'redefine';
    no strict 'refs';

    my @expected = (
        {
            disabled      => 1,
            dsp_types     => 1 | 4,
            id            => 2563166,
            postmoderated => 0,
            short_caption => 'thecaption',
            tag           => 'somebstag',
            url           => 'http://example.com/url',
            use_pnocsy    => 0,
        },
        {
            disabled      => 1,
            dsp_types     => 1 | 4 | 8,
            formats       => [1, 2,],
            id            => 2563166,
            postmoderated => 0,
            short_caption => 'thecaption',
            tag           => 'somebstag',
            url           => 'http://example.com/url',
            use_pnocsy    => 0,
        },
    );

    mock_subs(
        {
            'Application::Model::API::Yandex::SelfService::logbroker'                          => sub { },
            'QBit::Application::Model::API::Yandex::HTTPBK::_prepare_dsp_object_for_logbroker' => sub {
                my ($self, $data) = @_;

                eq_or_diff($data, shift(@expected), 'check preparing data');
            },
        }
    );

    my $result = $app->api_http_bk->dsp_lb(
        {
            disabled      => 1,
            dsp_types     => [0, 2,],
            id            => 2563166,
            postmoderated => 0,
            short_caption => 'thecaption',
            tag           => 'somebstag',
            url           => 'http://example.com/url',
            use_pnocsy    => 0,
        }
    );

    eq_or_diff($result, 1, 'correct finish');

    $result = $app->api_http_bk->dsp_lb(
        {
            disabled      => 1,
            dsp_types     => [0, 2,],
            formats       => [1, 2,],
            id            => 2563166,
            postmoderated => 0,
            short_caption => 'thecaption',
            tag           => 'somebstag',
            url           => 'http://example.com/url',
            use_pnocsy    => 0,
        }
    );

    eq_or_diff($result, 1, 'correct finish native');

    restore_subs('Application::Model::API::Yandex::SelfService::logbroker',
        'QBit::Application::Model::API::Yandex::HTTPBK::_prepare_dsp_object_for_logbroker');

    return 1;
}

sub with_validation_error {
    plan tests => 1;

    mock_subs(
        {
            'Application::Model::API::Yandex::SelfService::logbroker' => sub {
                fail 'method is called';
            },
            'QBit::Application::Model::API::Yandex::HTTPBK::_prepare_dsp_object_for_logbroker' => sub {
                fail 'method is called';
            },
        }
    );

    throws_ok {
        my $data = $app->api_http_bk->dsp_lb({});
    }
    'Exception::Validator::Errors', 'correct exception';

    restore_subs('Application::Model::API::Yandex::SelfService::logbroker',
        'QBit::Application::Model::API::Yandex::HTTPBK::_prepare_dsp_object_for_logbroker');

    return 1;
}

sub while_option_is_turned_off {
    plan tests => 1;

    mock_subs(
        {
            'Application::Model::API::Yandex::SelfService::logbroker' => sub {
                fail 'method is called';
            },
            'QBit::Application::Model::API::Yandex::HTTPBK::_prepare_dsp_object_for_logbroker' => sub {
                fail 'method is called';
            },
        }
    );

    $app->api_http_bk->set_option('allow_dsp_via_logbroker', 0);

    eq_or_diff($app->api_http_bk->dsp_lb({}), '', 'turn off dsp via http');

    restore_subs('Application::Model::API::Yandex::SelfService::logbroker',
        'QBit::Application::Model::API::Yandex::HTTPBK::_prepare_dsp_object_for_logbroker');

    return 1;
}

run_tests(
    sub {
        ($app) = @_;

        $app->api_http_bk->set_option('allow_dsp_via_logbroker', 1);

        subtest correct_dsp                => \&correct_dsp;
        subtest with_validation_error      => \&with_validation_error;
        subtest while_option_is_turned_off => \&while_option_is_turned_off;
    },
    init => [qw(api_http_bk api_selfservice)],
);
