use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;
use Test::Exception;

sub check_correct_answer {
    my ($app) = @_;

    no warnings 'redefine';
    no strict 'refs';

    *{'LWP::UserAgent::request'} = sub {
        my $r = HTTP::Response->new(200);
        $r->request(HTTP::Request->new());
        $r->content(
'{"data":[{"URL":"http://lamoda25.ru/rtb/yandex/bidder/lamoda/","Options":{"disabled":1,"non-blind":0,"dynamic":0,"postmoderated":0,"skipnoud":0},"DSPID":"2317558","Status":"0","DefaultAdType":"media","Readonly":"0","ShowProbability":"65.000000","DSPType":"1","TestURL":"","DataKey":"hidden","Tag":"lamoda"}],"code":0}',
        );
        return $r;
    };

    my $dsp_id = 2317558;
    my $data   = $app->api_http_bk->get_dsp_info($dsp_id);

    cmp_deeply(
        $data,
        [
            {
                DataKey       => "hidden",
                DefaultAdType => "media",
                DSPID         => 2317558,
                DSPType       => 1,
                Options       => {
                    disabled      => 1,
                    dynamic       => 0,
                    'non-blind'   => 0,
                    postmoderated => 0,
                    skipnoud      => 0,
                },
                Readonly        => 0,
                ShowProbability => '65.000000',
                Status          => 0,
                Tag             => "lamoda",
                TestURL         => "",
                URL             => "http://lamoda25.ru/rtb/yandex/bidder/lamoda/",
            },
        ],
    );

    return 1;
}

sub check_error_answer {
    my ($app) = @_;

    no warnings 'redefine';
    no strict 'refs';

    *{'LWP::UserAgent::request'} = sub {
        my $r = HTTP::Response->new(200);
        $r->request(HTTP::Request->new());
        $r->content(q({"error":"there's no such dsp_id = 444","code":1}),);
        return $r;
    };

    my $dsp_id = 444;

    throws_ok(
        sub {
            my $data = $app->api_http_bk->get_dsp_info($dsp_id);
        },
        'Exception::BK',
    );

    return 1;
}

run_tests(
    sub {
        my ($app) = @_;

        check_correct_answer($app);
        check_error_answer($app);
    }
);
