use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        no strict 'refs';
        no warnings 'redefine';

        local *{'QBit::Application::Model::API::Yandex::HTTPBK::call'} = sub {
            my ($self, $method, %opts) = @_;

            is($opts{date}, '20171214000000', 'got expected date in request');

            # БК возвращает \n после #End
            return "20171214000000\t250073\t542\t0\t1
20171214000000\t258894\t542\t0\t15
#End
";
        };

        is_deeply(
            $app->api_http_bk->get_page_block_shows('2017-12-14'),
            [
                {
                    Flag       => 0,
                    PageAdShow => 1,
                    PageID     => 250073,
                    PlaceID    => 542,
                    UpdateTime => '2017-12-14',
                },
                {
                    Flag       => 0,
                    PageAdShow => 15,
                    PageID     => 258894,
                    PlaceID    => 542,
                    UpdateTime => '2017-12-14',
                },
            ],
            'got exected data from get_page_block_shows()',
        );

        local *{'QBit::Application::Model::API::Yandex::HTTPBK::call'} = sub {
            my ($self, $method, %opts) = @_;

            # БК возвращает \n после #End
            return "#End\n";
        };

        is_deeply(
            $app->api_http_bk->get_page_block_shows('2017-12-13'),
            [], 'got exected empty data from get_page_block_shows()',
        );

        local *{'QBit::Application::Model::API::Yandex::HTTPBK::call'} = sub {
            my ($self, $method, %opts) = @_;

            return '';
        };

        eval {my $data = $app->api_http_bk->get_page_block_shows('2017-12-12')};

        is(ref($@), 'Exception::BK', 'get_page_block_shows() throws exception in case of error bk answer');
        is($@->message(), "export/export_pageblockshows.cgi - no '#End' marker", 'got expected error message');

    },
);
