use qbit;
use Test::More;
require QBit::Application::Model::API::Yandex::HTTPGeobase;

my @docker_ips = qw(
  172.17.0.52
  ::ffff:172.17.0.121
  );

foreach my $ip (@docker_ips) {
    ok(QBit::Application::Model::API::Yandex::HTTPGeobase::_is_docker_ip(undef, $ip), 'true - ' . $ip);
}

my @not_docker_ips = ('8.8.8.8', '5.255.233.226', '2a02:6b8:0:40c:a8c8:699a:797d:8c74', undef, {}, [],);

foreach my $ip (@not_docker_ips) {
    ok(!QBit::Application::Model::API::Yandex::HTTPGeobase::_is_docker_ip(undef, $ip), 'false - ' . ($ip // 'undef'));
}

done_testing();
