#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Partner2::Simple;
use Test::More tests => 3;
use Test::MockObject::Extends;

$ENV{LAZY_LOAD} = FALSE;

run_tests(
    sub {
        my ($app) = @_;

        my @data = (
            {
                'value' => 1,
                'path'  => 'API.HTTPMAAS.balance_memcached'
            }
        );

        no warnings 'redefine';
        no strict 'refs';
        *{'QBit::Application::Model::API::Yandex::HTTPMAAS::send_to_graphite'} = sub {
            my %data = @_;
            is_deeply(\%data, shift @data, 'results sent to graphite');
        };
        *{'QBit::Application::Model::Memcached::get'} = sub {memcached_data()};

        $app->api_http_maas->find_app('com.askfm', 1);
    },
    do_not_die_on_fail => 1,
);

sub memcached_data {
    return {
        'request_query' => 'country:"ru" app_id:"com.askfm" content_type:"app" store:"gplay"',
        'page'          => '0',
        'response'      => {
            'searcher_properties' => {
                'MisspellCode'                    => '0',
                'RequestedRankingModel'           => '',
                'Ig'                              => '0',
                'Unanswer_0_TIER'                 => '4/0',
                'scheme.json.nodump'              => '{}',
                'RankingModel'                    => 'default',
                'Unanswer_1_TIER'                 => '0/0',
                'SourceTimestamp'                 => '4294967295',
                'Unanswer_mobile-application-rus' => '4/0',
                'RankingMn'                       => '',
                'MobileApplicationRoute.Country'  => 'ru',
                'Unanswer_'                       => '4/0',
                'WaitInfo2.debug' =>
'Cl4KBGxhc3QSBnNlYXJjaBowaW5wcm9jOi8vbG9jYWxob3N0OjE3MDAxL21vYmlsZS1hcHBsaWNhdGlvbi1ydXM/IAEqFyNtb2JpbGUtYXBwbGljYXRpb24tcnVzMIYf',
                'RankingIntMn'                       => '',
                'HostName'                           => 'sas1-2502.search.yandex.net:17000',
                'ExtensionsRankModel'                => '',
                'MisspellApplied'                    => '0',
                'SuperMindMult'                      => '0',
                'Acc'                                => '0',
                'MobileApplicationRoute.ContentType' => 'app',
                'MobileApplicationRoute.Store'       => 'gplay',
                'BsTouched'                          => '0',
                'Nctx'                               => '2'
            },
            'found' => {
                'strict' => '1',
                'phrase' => '1',
                'all'    => '1'
            },
            'results' => [
                {
                    'groups-on-page' => '10',
                    'mode'           => 0,
                    'groups'         => [
                        {
                            'documents' => [
                                {
                                    'docId'     => '0-0-1-ZF3EB135F1E9FAABF',
                                    'relevance' => '102113248',
                                    'url'   => 'https://play.google.com/store/apps/details?id=com.askfm&hl=ru&gl=ru',
                                    'title' => [
                                        {
                                            'text' =>
"ASKfm - \x{d0}\x{97}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}"
                                        }
                                    ],
                                    'headline' => [
                                        {
                                            'text' =>
"APPLICATION. Ask.fm. com.askfm. \x{d0}\x{91}\x{d0}\x{be}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b5} 215 \x{d0}\x{bc}\x{d0}\x{bb}\x{d0}\x{bd} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{b7}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{82}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b9} \x{d0}\x{bb}\x{d1}\x{8e}\x{d0}\x{b1}\x{d1}\x{8f}\x{d1}\x{82} ASKfm! ASKfm \x{e2}\x{80}\x{93} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} \x{e2}\x{84}\x{96} 1 \x{d0}\x{b4}\x{d0}\x{bb}\x{d1}\x{8f} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d0}\x{be}\x{d0}\x{b2} \x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b2}, \x{d0}\x{b3}\x{d0}\x{b4}\x{d0}\x{b5} \x{d0}\x{b2}\x{d1}\x{8b} \x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d1}\x{83}\x{d0}\x{b7}\x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{8c}\x{d1}\x{88}\x{d0}\x{b5} \x{d0}\x{be} \x{d1}\x{81}\x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{b8}\x{d1}\x{85} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b7}\x{d1}\x{8c}\x{d1}\x{8f}\x{d1}\x{85}..."
                                        }
                                    ],
                                    'properties' => {
                                        'website' => 'http://support.ask.fm',
                                        'reviews_author' =>
" Nastya Yakusheva \x{d0}\x{90}\x{d0}\x{bd}\x{d0}\x{b4}\x{d1}\x{80}\x{d0}\x{b5}\x{d0}\x{b9} \x{d0}\x{91}\x{d0}\x{b5}\x{d0}\x{b7} \x{d0}\x{92}\x{d0}\x{b0}\x{d0}\x{b3}\x{d0}\x{b5}\x{d0}\x{bd} \x{d0}\x{98}\x{d0}\x{bc}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8} \x{d0}\x{9a}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{b0}\x{d0}\x{b7} \x{d0}\x{a6}\x{d1}\x{86}",
                                        'screens_ex' =>
'[{"extra": {"svg": {"path": "/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/svg"}}, "imagename": "12cb6efcae69697bb22441432c55659c", "meta": {"orig-size": {"y": 2048, "x": 1200}, "orig-format": "PNG", "processed_by_computer_vision": true, "processing": "finished", "r-orig-size": {"y": 1400, "x": 820}, "SmartCrop": {"320x240": {"FitLevel": 0.824311, "Rect": [42, 435, 1158, 869]}, "160x120": {"FitLevel": 0.822918, "Rect": [70, 442, 1130, 847]}}, "crc64": "7A8A8FD6B5EB2B80", "MainColor": "#F86048", "orig-orientation": "", "md5": "ccb766da9a41756e52504ee7f60741de"}, "group-id": 114777, "sizes": {"gallery_crop": {"path": "/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/gallery_crop", "height": 120, "width": 160}, "gallery_retina": {"path": "/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/gallery_retina", "height": 240, "width": 141}, "gallery_retina_crop": {"path": "/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/gallery_retina_crop", "height": 240, "width": 320}, "preview": {"path": "/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/preview", "height": 320, "width": 188}, "gallery": {"path": "/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/gallery", "height": 120, "width": 70}, "orig": {"path": "/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/orig", "height": 2048, "width": 1200}}}, {"extra": {"svg": {"path": "/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/svg"}}, "imagename": "7fc68f1d9c82a3846328bea6d655f0de", "meta": {"orig-size": {"y": 2048, "x": 1200}, "orig-format": "PNG", "processed_by_computer_vision": true, "processing": "finished", "r-orig-size": {"y": 1400, "x": 820}, "SmartCrop": {"320x240": {"FitLevel": 0.73259, "Rect": [0, 544, 1200, 901]}, "160x120": {"FitLevel": 0.728599, "Rect": [0, 521, 1200, 900]}}, "crc64": "4452552E4EE467F6", "MainColor": "#484850", "orig-orientation": "", "md5": "ec831948317c87ab7c2fcd787467dc60"}, "group-id": 466137, "sizes": {"gallery_crop": {"path": "/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/gallery_crop", "height": 120, "width": 160}, "gallery_retina": {"path": "/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/gallery_retina", "height": 240, "width": 141}, "gallery_retina_crop": {"path": "/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/gallery_retina_crop", "height": 240, "width": 320}, "preview": {"path": "/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/preview", "height": 320, "width": 188}, "gallery": {"path": "/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/gallery", "height": 120, "width": 70}, "orig": {"path": "/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/orig", "height": 2048, "width": 1200}}}, {"extra": {"svg": {"path": "/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/svg"}}, "imagename": "100834736c36e9e9aaea4837076ba04d", "meta": {"orig-size": {"y": 2048, "x": 1200}, "orig-format": "PNG", "processed_by_computer_vision": true, "processing": "finished", "r-orig-size": {"y": 1400, "x": 820}, "SmartCrop": {"320x240": {"FitLevel": 0.867031, "Rect": [0, 840, 1200, 900]}, "160x120": {"FitLevel": 0.874548, "Rect": [0, 773, 1200, 901]}}, "crc64": "EC9A73B82C988065", "MainColor": "#C03048", "orig-orientation": "", "md5": "85c94914461cc3d8ce6a5b4f7ea7b062"}, "group-id": 466137, "sizes": {"gallery_crop": {"path": "/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/gallery_crop", "height": 120, "width": 160}, "gallery_retina": {"path": "/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/gallery_retina", "height": 240, "width": 141}, "gallery_retina_crop": {"path": "/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/gallery_retina_crop", "height": 240, "width": 320}, "preview": {"path": "/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/preview", "height": 320, "width": 188}, "gallery": {"path": "/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/gallery", "height": 120, "width": 70}, "orig": {"path": "/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/orig", "height": 2048, "width": 1200}}}, {"extra": {"svg": {"path": "/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/svg"}}, "imagename": "1d650cb1a9df34438fab4ce92ca8e609", "meta": {"orig-size": {"y": 2048, "x": 1200}, "orig-format": "PNG", "processed_by_computer_vision": true, "processing": "finished", "r-orig-size": {"y": 1400, "x": 820}, "SmartCrop": {"320x240": {"FitLevel": 0.942118, "Rect": [0, 713, 1200, 901]}, "160x120": {"FitLevel": 0.942309, "Rect": [0, 689, 1200, 900]}}, "crc64": "4C73D9C2E8007E51", "MainColor": "#582050", "orig-orientation": "", "md5": "26846be78d0bae023f9dee560398d48d"}, "group-id": 218654, "sizes": {"gallery_crop": {"path": "/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/gallery_crop", "height": 120, "width": 160}, "gallery_retina": {"path": "/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/gallery_retina", "height": 240, "width": 141}, "gallery_retina_crop": {"path": "/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/gallery_retina_crop", "height": 240, "width": 320}, "preview": {"path": "/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/preview", "height": 320, "width": 188}, "gallery": {"path": "/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/gallery", "height": 120, "width": 70}, "orig": {"path": "/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/orig", "height": 2048, "width": 1200}}}, {"extra": {"svg": {"path": "/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/svg"}}, "imagename": "6d542729c612938b2890834740af4e5e", "meta": {"orig-size": {"y": 2048, "x": 1200}, "orig-format": "PNG", "processed_by_computer_vision": true, "processing": "finished", "r-orig-size": {"y": 1400, "x": 820}, "SmartCrop": {"320x240": {"FitLevel": 0.624049, "Rect": [0, 82, 1200, 901]}, "160x120": {"FitLevel": 0.622303, "Rect": [0, 59, 1200, 900]}}, "crc64": "E617D690640E02B4", "MainColor": "#28C0D0", "orig-orientation": "", "md5": "a620fd3c8aaafd172fa6c9763e804902"}, "group-id": 403753, "sizes": {"gallery_crop": {"path": "/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/gallery_crop", "height": 120, "width": 160}, "gallery_retina": {"path": "/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/gallery_retina", "height": 240, "width": 141}, "gallery_retina_crop": {"path": "/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/gallery_retina_crop", "height": 240, "width": 320}, "preview": {"path": "/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/preview", "height": 320, "width": 188}, "gallery": {"path": "/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/gallery", "height": 120, "width": 70}, "orig": {"path": "/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/orig", "height": 2048, "width": 1200}}}]',
                                        'os_version' =>
"4.1 \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b5} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{b7}\x{d0}\x{b4}\x{d0}\x{bd}\x{d1}\x{8f}\x{d1}\x{8f}",
                                        'genres' =>
"[\"\x{d0}\x{a1}\x{d0}\x{be}\x{d1}\x{86}\x{d0}\x{b8}\x{d0}\x{b0}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{bd}\x{d1}\x{8b}\x{d0}\x{b5}\"]",
                                        'date_release_ts' => '1517259600',
                                        'id'              => 'com.askfm',
                                        'publisher'       => 'Ask.fm',
                                        'adult'           => '12+',
                                        'icon_ex' =>
'{"imagename": "0bb5cbb5b263d795679f55c0c5609d55", "meta": {"ColorWizText": "#F3C2CB", "orig-size": {"y": 512, "x": 512}, "orig-format": "PNG", "processed_by_computer_vision": "true", "processing": "finished", "r-orig-size": {"y": 512, "x": 512}, "ColorWizButtonText": "#E67589", "ColorWizButton": "#DA3E59", "ColorWizBack": "#D83450", "MainColor": "#D83050", "orig-orientation": "", "AverageBorderColor": "#D83450", "md5": "73af054abdf2810dc9dd2cd81bffc799"}, "group-id": 40210, "sizes": {"icon-s": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-s", "width": 16, "height": 16}, "icon-xxxhdi": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-xxxhdi", "width": 192, "height": 192}, "icon-xld-retina": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-xld-retina", "width": 300, "height": 300}, "icon-ldd": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-ldd", "width": 90, "height": 90}, "icon-ld": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-ld", "width": 80, "height": 80}, "icon-xl": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-xl", "width": 144, "height": 144}, "orig": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/orig", "width": 512, "height": 512}, "icon-s-retina": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-s-retina", "width": 32, "height": 32}, "icon-xhdpi": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-xhdpi", "width": 96, "height": 96}, "icon-xld": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-xld", "width": 150, "height": 150}, "icon-mdpi": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-mdpi", "width": 48, "height": 48}, "icon-ld-retina": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-ld-retina", "width": 160, "height": 160}, "icon": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon", "width": 65, "height": 65}, "icon-lr": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-lr", "width": 72, "height": 72}, "icon-l": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-l", "width": 72, "height": 72}, "icon-ldd-retina": {"path": "/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-ldd-retina", "width": 180, "height": 180}}}',
                                        'screens' =>
'http://avatars.mds.yandex.net/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/orig http://avatars.mds.yandex.net/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/orig http://avatars.mds.yandex.net/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/orig http://avatars.mds.yandex.net/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/orig http://avatars.mds.yandex.net/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/orig',
                                        '_BM25F_Sy_description_small' => ['0', '0', '0'],
                                        'release_date' =>
"30 \x{d1}\x{8f}\x{d0}\x{bd}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{80}\x{d1}\x{8f} 2018 \x{d0}\x{b3}.",
                                        'subcategory_eng' => '["SOCIAL"]',
                                        'name' =>
"ASKfm - \x{d0}\x{97}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}",
                                        'reviews' =>
" \x{d0}\x{92} \x{d0}\x{92}\x{d0}\x{9a} \x{d0}\x{92}\x{d0}\x{b0}\x{d1}\x{83} \x{d0}\x{92}\x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bb}\x{d0}\x{bd}\x{d0}\x{b5} \x{d0}\x{92}\x{d1}\x{81}\x{d0}\x{b5}\x{d0}\x{bc} \x{d0}\x{94}\x{d0}\x{be}\x{d1}\x{80}\x{d0}\x{be}\x{d0}\x{b3}\x{d0}\x{b8}\x{d0}\x{b5} \x{d0}\x{95}\x{d0}\x{b4}\x{d0}\x{b8}\x{d0}\x{bd}\x{d1}\x{81}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{bd}\x{d1}\x{8b}\x{d0}\x{b9} \x{d0}\x{98} \x{d0}\x{9c}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d1}\x{82} \x{d0}\x{9d}\x{d0}\x{b8}\x{d0}\x{ba}\x{d0}\x{b0}\x{d0}\x{ba}\x{d0}\x{b8}\x{d1}\x{85} \x{d0}\x{9e}\x{d0}\x{b4}\x{d0}\x{b0} \x{d0}\x{9f}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} \x{d0}\x{a5}\x{d0}\x{be}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{88}\x{d0}\x{b5}\x{d0}\x{b5} \x{d0}\x{a5}\x{d0}\x{be}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{88}\x{d0}\x{be} \x{d0}\x{af} \x{d0}\x{b1}\x{d0}\x{b0}\x{d0}\x{b3}\x{d0}\x{be}\x{d0}\x{b2} \x{d0}\x{b1}\x{d1}\x{83}\x{d0}\x{b4}\x{d1}\x{83} \x{d0}\x{b1}\x{d1}\x{8b} \x{d0}\x{b1}\x{d1}\x{8b}\x{d0}\x{bb}\x{d0}\x{be} \x{d0}\x{b2} \x{d0}\x{b2}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{b8}\x{d0}\x{ba}\x{d0}\x{be}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{bf}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{b7}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d0}\x{bb}\x{d1}\x{8b}\x{d0}\x{bc} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{b2}\x{d1}\x{81}\x{d1}\x{91} \x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b6}\x{d0}\x{b5} \x{d0}\x{b4}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{b0}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{b4}\x{d0}\x{b8}\x{d1}\x{80}\x{d0}\x{b5}\x{d0}\x{ba}\x{d1}\x{82}\x{d0}\x{b0} \x{d0}\x{b4}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b8}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{b4}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{b0}\x{d0}\x{b2}\x{d1}\x{8c}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b5}\x{d1}\x{81}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b5}\x{d1}\x{81}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{b5}\x{d1}\x{91} \x{d0}\x{b7}\x{d0}\x{b0} \x{d0}\x{b7}\x{d0}\x{b0}\x{d1}\x{87}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{8f} \x{d0}\x{b7}\x{d0}\x{b2}\x{d0}\x{b5}\x{d0}\x{b7}\x{d0}\x{b4}\x{d1}\x{8b} \x{d0}\x{b8} \x{d0}\x{ba}\x{d0}\x{be}\x{d0}\x{b3}\x{d0}\x{be} \x{d0}\x{ba}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d0}\x{bc}\x{d0}\x{b8}\x{d0}\x{bd}\x{d1}\x{83}\x{d1}\x{81} \x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{b5} \x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b3}\x{d0}\x{be} \x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b5}\x{d0}\x{b9} \x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{bc}\x{d0}\x{b5}\x{d0}\x{bd}\x{d1}\x{82}\x{d0}\x{b0} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{bd}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b8} \x{d0}\x{bd}\x{d0}\x{b5} \x{d0}\x{bd}\x{d0}\x{b5}\x{d0}\x{b7}\x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{8e} \x{d0}\x{bd}\x{d0}\x{b5}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{b7}\x{d1}\x{8f} \x{d0}\x{bd}\x{d0}\x{b5}\x{d0}\x{bf}\x{d0}\x{bb}\x{d0}\x{be}\x{d1}\x{85}\x{d0}\x{be} \x{d0}\x{bd}\x{d0}\x{b5}\x{d1}\x{84}\x{d0}\x{b8}\x{d0}\x{b3} \x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b1}\x{d1}\x{83}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{bd}\x{d0}\x{be}\x{d1}\x{80}\x{d0}\x{bc}\x{d0}\x{b0}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b8}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8b} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{bb}\x{d0}\x{b8}\x{d1}\x{87}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b5} \x{d0}\x{bf}\x{d0}\x{bb}\x{d0}\x{b0}\x{d0}\x{bd}\x{d1}\x{8b} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{b4}\x{d0}\x{bf}\x{d0}\x{b8}\x{d1}\x{81}\x{d1}\x{87}\x{d0}\x{b8}\x{d0}\x{ba}\x{d0}\x{be}\x{d0}\x{b2} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b0}\x{d0}\x{bb}\x{d1}\x{83}\x{d0}\x{b9}\x{d1}\x{81}\x{d1}\x{82}\x{d0}\x{b0} \x{d0}\x{bf}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{b7}\x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{82}\x{d0}\x{b5}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d1}\x{83} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d0}\x{b3}\x{d0}\x{b0} \x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b7}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b1}\x{d0}\x{be}\x{d1}\x{82}\x{d1}\x{87}\x{d0}\x{b8}\x{d0}\x{ba}\x{d0}\x{b8} \x{d1}\x{80}\x{d0}\x{b5}\x{d0}\x{ba}\x{d0}\x{bb}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{b0} \x{d1}\x{80}\x{d0}\x{b5}\x{d1}\x{88}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} \x{d1}\x{81}\x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{b8} \x{d1}\x{81}\x{d0}\x{b8}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{bd}\x{d0}\x{be} \x{d1}\x{81}\x{d0}\x{bc}\x{d0}\x{be}\x{d1}\x{82}\x{d1}\x{80}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8c} \x{d1}\x{81}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{83}\x{d1}\x{8e} \x{d1}\x{81}\x{d0}\x{bf}\x{d0}\x{b8}\x{d1}\x{81}\x{d0}\x{be}\x{d0}\x{ba} \x{d1}\x{81}\x{d1}\x{82}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{bb}\x{d1}\x{8e} \x{d1}\x{81}\x{d1}\x{82}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{b8}\x{d1}\x{86}\x{d0}\x{b5} \x{d1}\x{82}\x{d0}\x{b0}\x{d0}\x{ba} \x{d1}\x{82}\x{d0}\x{b0}\x{d0}\x{bc} \x{d1}\x{82}\x{d0}\x{b5}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{be} \x{d1}\x{82}\x{d0}\x{b8}\x{d0}\x{bf}\x{d0}\x{be} \x{d1}\x{82}\x{d0}\x{be} \x{d1}\x{83}\x{d0}\x{b2}\x{d0}\x{b8}\x{d0}\x{b4}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8c} \x{d1}\x{83}\x{d0}\x{b4}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b5} \x{d1}\x{85}\x{d0}\x{be}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{88}\x{d0}\x{be} \x{d1}\x{86}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{bc} \x{d1}\x{87}\x{d1}\x{82}\x{d0}\x{be} \x{d1}\x{88}\x{d0}\x{bf}\x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{b0} \x{d1}\x{8d}\x{d1}\x{82}\x{d0}\x{be} \x{d1}\x{8d}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b3}\x{d0}\x{be}",
                                        'description' =>
"{\"html_description\": \"\x{d0}\x{91}\x{d0}\x{be}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b5} 215\x{c2}\x{a0}\x{d0}\x{bc}\x{d0}\x{bb}\x{d0}\x{bd} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{b7}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{82}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b9} \x{d0}\x{bb}\x{d1}\x{8e}\x{d0}\x{b1}\x{d1}\x{8f}\x{d1}\x{82} ASKfm! ASKfm\x{c2}\x{a0}\x{e2}\x{80}\x{93} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} \x{e2}\x{84}\x{96}\x{c2}\x{a0}1 \x{d0}\x{b4}\x{d0}\x{bb}\x{d1}\x{8f} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d0}\x{be}\x{d0}\x{b2} \x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b2}, \x{d0}\x{b3}\x{d0}\x{b4}\x{d0}\x{b5} \x{d0}\x{b2}\x{d1}\x{8b} \x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d1}\x{83}\x{d0}\x{b7}\x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{8c}\x{d1}\x{88}\x{d0}\x{b5} \x{d0}\x{be} \x{d1}\x{81}\x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{b8}\x{d1}\x{85} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b7}\x{d1}\x{8c}\x{d1}\x{8f}\x{d1}\x{85}, \x{d0}\x{b7}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{8f} \x{d0}\x{b8}\x{d0}\x{bc} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{b8} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{83}\x{d1}\x{87}\x{d0}\x{b0}\x{d1}\x{8f} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8b}. \x{d0}\x{a1}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b8}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{ba}\x{d0}\x{b0}\x{d0}\x{ba} \x{d1}\x{85}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5}\x{c2}\x{a0}\x{e2}\x{80}\x{93} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{bd}\x{d0}\x{b5}\x{d1}\x{82}. \x{d0}\x{ad}\x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{81}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{be} \x{d0}\x{b8} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{82}\x{d0}\x{be}, \x{d0}\x{b8} \x{d0}\x{b2}\x{d1}\x{8b} \x{d0}\x{bd}\x{d0}\x{b5} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{80}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5}, \x{d0}\x{ba}\x{d0}\x{b0}\x{d0}\x{ba} \x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b3}\x{d0}\x{be} \x{d0}\x{b2}\x{d1}\x{8b} \x{d1}\x{83}\x{d0}\x{b7}\x{d0}\x{bd}\x{d0}\x{b0}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{be} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b3}\x{d0}\x{b8}\x{d1}\x{85} \x{d0}\x{b8} \x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b6}\x{d0}\x{b5} \x{d0}\x{be} \x{d1}\x{81}\x{d0}\x{b5}\x{d0}\x{b1}\x{d0}\x{b5}! <br>\x{d0}\x{9a}\x{d0}\x{b0}\x{d0}\x{b6}\x{d0}\x{b4}\x{d1}\x{8b}\x{d0}\x{b9} \x{d0}\x{b4}\x{d0}\x{b5}\x{d0}\x{bd}\x{d1}\x{8c} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{b7}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{82}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{b8} ASKfm \x{d0}\x{b2}\x{d0}\x{be} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5}\x{d0}\x{bc} \x{d0}\x{bc}\x{d0}\x{b8}\x{d1}\x{80}\x{d0}\x{b5} \x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{bc}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{8e}\x{d1}\x{82}\x{d1}\x{81}\x{d1}\x{8f} \x{d0}\x{bc}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{bb}\x{d0}\x{b8}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{b8} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d0}\x{be}\x{d0}\x{b2} \x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b2} \x{d0}\x{bd}\x{d0}\x{b0} 40 \x{d1}\x{81} \x{d0}\x{bb}\x{d0}\x{b8}\x{d1}\x{88}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc} \x{d1}\x{8f}\x{d0}\x{b7}\x{d1}\x{8b}\x{d0}\x{ba}\x{d0}\x{b0}\x{d1}\x{85}. \x{d0}\x{9e}\x{d1}\x{82}\x{d0}\x{ba}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b2} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5}, \x{d0}\x{b2}\x{d1}\x{8b} \x{d1}\x{83}\x{d0}\x{b2}\x{d0}\x{b8}\x{d0}\x{b4}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}, \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b8} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b7}\x{d1}\x{8c}\x{d1}\x{8f}, \x{d0}\x{b8} \x{d1}\x{81}\x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b8}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}, \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{b1}\x{d1}\x{8b}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d1}\x{81}\x{d0}\x{bb}\x{d0}\x{b0}\x{d0}\x{bd}\x{d1}\x{8b} \x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{bc}. \x{d0}\x{92}\x{d0}\x{be}\x{d1}\x{82} \x{d1}\x{87}\x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b5}\x{d0}\x{b4}\x{d0}\x{bb}\x{d0}\x{b0}\x{d0}\x{b3}\x{d0}\x{b0}\x{d0}\x{b5}\x{d1}\x{82} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} ASKfm:<br><br>  \x{e2}\x{80}\x{a2} \x{d0}\x{97}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{bb}\x{d1}\x{8e}\x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b3}\x{d1}\x{83}\x{c2}\x{a0}\x{e2}\x{80}\x{93} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{bd}\x{d0}\x{b5}\x{d1}\x{82}.<br>  \x{e2}\x{80}\x{a2} \x{d0}\x{9f}\x{d0}\x{be}\x{d0}\x{b4}\x{d0}\x{bf}\x{d0}\x{b8}\x{d1}\x{81}\x{d1}\x{8b}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5}\x{d1}\x{81}\x{d1}\x{8c} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b7}\x{d0}\x{b5}\x{d0}\x{b9}, \x{d1}\x{87}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b1}\x{d1}\x{8b} \x{d0}\x{b2}\x{d0}\x{b8}\x{d0}\x{b4}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}, \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{87}\x{d0}\x{b0}\x{d1}\x{8e}\x{d1}\x{82}. <br>  \x{e2}\x{80}\x{a2} \x{d0}\x{9c}\x{d0}\x{b3}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{b4}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{bb}\x{d1}\x{8f}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d1}\x{84}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b3}\x{d1}\x{80}\x{d0}\x{b0}\x{d1}\x{84}\x{d0}\x{b8}\x{d0}\x{b8} \x{d0}\x{b8} \x{d0}\x{b3}\x{d0}\x{b8}\x{d1}\x{84}\x{d0}\x{ba}\x{d0}\x{b8} \x{d0}\x{ba} \x{d0}\x{bb}\x{d1}\x{8e}\x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{83}.<br>  \x{e2}\x{80}\x{a2} \x{d0}\x{a1}\x{d0}\x{bc}\x{d0}\x{be}\x{d1}\x{82}\x{d1}\x{80}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{84}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d1}\x{82}\x{d0}\x{b5}\x{d1}\x{85}, \x{d0}\x{ba}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bd}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8}\x{d1}\x{81}\x{d1}\x{8c} \x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8b} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}.<br>  \x{e2}\x{80}\x{a2} \x{d0}\x{91}\x{d0}\x{b5}\x{d0}\x{b7}\x{d0}\x{be}\x{d0}\x{bf}\x{d0}\x{b0}\x{d1}\x{81}\x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{8f} \x{d1}\x{81}\x{d1}\x{80}\x{d0}\x{b5}\x{d0}\x{b4}\x{d0}\x{b0}, \x{d0}\x{b2} \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d0}\x{be}\x{d0}\x{b9} \x{d0}\x{b2}\x{d1}\x{8b} \x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d1}\x{81}\x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{b4}\x{d0}\x{bd}\x{d0}\x{be} \x{d1}\x{81}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b2}\x{d1}\x{8b}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b6}\x{d0}\x{b0}\x{d1}\x{82}\x{d1}\x{8c}\x{d1}\x{81}\x{d1}\x{8f}. <br>  \x{e2}\x{80}\x{a2} \x{d0}\x{9e}\x{d1}\x{82}\x{d0}\x{ba}\x{d0}\x{bb}\x{d1}\x{8e}\x{d1}\x{87}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{be}\x{d1}\x{82} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5}\x{d1}\x{85}, \x{d0}\x{ba}\x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{bc} \x{d0}\x{bd}\x{d0}\x{b5} \x{d0}\x{bd}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b8}\x{d1}\x{82}\x{d1}\x{81}\x{d1}\x{8f}. <br><br>\x{d0}\x{95}\x{d1}\x{81}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{bc}\x{d1}\x{8b} \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}? \x{d0}\x{97}\x{d0}\x{b0}\x{d1}\x{85}\x{d0}\x{be}\x{d0}\x{b4}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{bd}\x{d0}\x{b0} http://support.ask.fm \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b7}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b5}\x{d0}\x{bc} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{84}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b5}: http://ask.fm/askfmhelp. <br><br>\x{d0}\x{a1}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b4}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b7}\x{d0}\x{b0} \x{d0}\x{bd}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{b8} \x{d0}\x{b2}: <br>Instagram https://www.instagram.com/askfm/<br>Facebook https://www.facebook.com/askfmpage<br>Twitter https://twitter.com/askfm<br>VKontakte https://vk.com/askfm\", \"rating\": {\"votes\": 1214084, \"value\": 4.106995105743408}, \"detected_lang\": \"ru\", \"subcategory\": [\"\x{d0}\x{a1}\x{d0}\x{be}\x{d1}\x{86}\x{d0}\x{b8}\x{d0}\x{b0}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{bd}\x{d1}\x{8b}\x{d0}\x{b5}\"], \"date_release\": \"30 \x{d1}\x{8f}\x{d0}\x{bd}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{80}\x{d1}\x{8f} 2018 \x{d0}\x{b3}.\", \"screens\": [\"http://avatars.mds.yandex.net/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/orig\", \"http://avatars.mds.yandex.net/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/orig\", \"http://avatars.mds.yandex.net/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/orig\", \"http://avatars.mds.yandex.net/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/orig\", \"http://avatars.mds.yandex.net/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/orig\"], \"likes\": 0, \"WhatsNew\": null, \"id\": \"com.askfm\", \"date_release_ts\": \"1517259600\", \"downloads\": \"50000000\x{e2}\x{80}\x{93}100000000\", \"title_eng\": \"ASKfm - Ask Me Anonymous Questions\", \"requirements\": \"4.1 \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b5} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{b7}\x{d0}\x{b4}\x{d0}\x{bd}\x{d1}\x{8f}\x{d1}\x{8f}\", \"author\": {\"website\": \"http://support.ask.fm\", \"id\": \"Ask.fm\", \"email\": \"app\@ask.fm\", \"name\": \"Ask.fm\"}, \"is_alpha\": false, \"version\": \"4.9\", \"ownCategories\": [], \"price\": {\"currency\": \"RUB\", \"value\": 0}, \"description\": \"\x{d0}\x{91}\x{d0}\x{be}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b5} 215 \x{d0}\x{bc}\x{d0}\x{bb}\x{d0}\x{bd} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{b7}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{82}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b9} \x{d0}\x{bb}\x{d1}\x{8e}\x{d0}\x{b1}\x{d1}\x{8f}\x{d1}\x{82} ASKfm! ASKfm \x{e2}\x{80}\x{93} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} \x{e2}\x{84}\x{96} 1 \x{d0}\x{b4}\x{d0}\x{bb}\x{d1}\x{8f} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d0}\x{be}\x{d0}\x{b2} \x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b2}, \x{d0}\x{b3}\x{d0}\x{b4}\x{d0}\x{b5} \x{d0}\x{b2}\x{d1}\x{8b} \x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d1}\x{83}\x{d0}\x{b7}\x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{8c}\x{d1}\x{88}\x{d0}\x{b5} \x{d0}\x{be} \x{d1}\x{81}\x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{b8}\x{d1}\x{85} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b7}\x{d1}\x{8c}\x{d1}\x{8f}\x{d1}\x{85}, \x{d0}\x{b7}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{8f} \x{d0}\x{b8}\x{d0}\x{bc} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{b8} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{83}\x{d1}\x{87}\x{d0}\x{b0}\x{d1}\x{8f} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8b}. \x{d0}\x{a1}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b8}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{ba}\x{d0}\x{b0}\x{d0}\x{ba} \x{d1}\x{85}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{e2}\x{80}\x{93} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{bd}\x{d0}\x{b5}\x{d1}\x{82}. \x{d0}\x{ad}\x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{81}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{be} \x{d0}\x{b8} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{82}\x{d0}\x{be}, \x{d0}\x{b8} \x{d0}\x{b2}\x{d1}\x{8b} \x{d0}\x{bd}\x{d0}\x{b5} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{80}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5}, \x{d0}\x{ba}\x{d0}\x{b0}\x{d0}\x{ba} \x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b3}\x{d0}\x{be} \x{d0}\x{b2}\x{d1}\x{8b} \x{d1}\x{83}\x{d0}\x{b7}\x{d0}\x{bd}\x{d0}\x{b0}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{be} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b3}\x{d0}\x{b8}\x{d1}\x{85} \x{d0}\x{b8} \x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b6}\x{d0}\x{b5} \x{d0}\x{be} \x{d1}\x{81}\x{d0}\x{b5}\x{d0}\x{b1}\x{d0}\x{b5}! \x{d0}\x{9a}\x{d0}\x{b0}\x{d0}\x{b6}\x{d0}\x{b4}\x{d1}\x{8b}\x{d0}\x{b9} \x{d0}\x{b4}\x{d0}\x{b5}\x{d0}\x{bd}\x{d1}\x{8c} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{b7}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{82}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{b8} ASKfm \x{d0}\x{b2}\x{d0}\x{be} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5}\x{d0}\x{bc} \x{d0}\x{bc}\x{d0}\x{b8}\x{d1}\x{80}\x{d0}\x{b5} \x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{bc}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{8e}\x{d1}\x{82}\x{d1}\x{81}\x{d1}\x{8f} \x{d0}\x{bc}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{bb}\x{d0}\x{b8}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{b8} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d0}\x{be}\x{d0}\x{b2} \x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b2} \x{d0}\x{bd}\x{d0}\x{b0} 40 \x{d1}\x{81} \x{d0}\x{bb}\x{d0}\x{b8}\x{d1}\x{88}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc} \x{d1}\x{8f}\x{d0}\x{b7}\x{d1}\x{8b}\x{d0}\x{ba}\x{d0}\x{b0}\x{d1}\x{85}. \x{d0}\x{9e}\x{d1}\x{82}\x{d0}\x{ba}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b2} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5}, \x{d0}\x{b2}\x{d1}\x{8b} \x{d1}\x{83}\x{d0}\x{b2}\x{d0}\x{b8}\x{d0}\x{b4}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}, \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b8} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b7}\x{d1}\x{8c}\x{d1}\x{8f}, \x{d0}\x{b8} \x{d1}\x{81}\x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b8}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}, \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{b1}\x{d1}\x{8b}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d1}\x{81}\x{d0}\x{bb}\x{d0}\x{b0}\x{d0}\x{bd}\x{d1}\x{8b} \x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{bc}. \x{d0}\x{92}\x{d0}\x{be}\x{d1}\x{82} \x{d1}\x{87}\x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b5}\x{d0}\x{b4}\x{d0}\x{bb}\x{d0}\x{b0}\x{d0}\x{b3}\x{d0}\x{b0}\x{d0}\x{b5}\x{d1}\x{82} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} ASKfm: \x{e2}\x{80}\x{a2} \x{d0}\x{97}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{bb}\x{d1}\x{8e}\x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b3}\x{d1}\x{83} \x{e2}\x{80}\x{93} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{bd}\x{d0}\x{b5}\x{d1}\x{82}. \x{e2}\x{80}\x{a2} \x{d0}\x{9f}\x{d0}\x{be}\x{d0}\x{b4}\x{d0}\x{bf}\x{d0}\x{b8}\x{d1}\x{81}\x{d1}\x{8b}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5}\x{d1}\x{81}\x{d1}\x{8c} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b7}\x{d0}\x{b5}\x{d0}\x{b9}, \x{d1}\x{87}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b1}\x{d1}\x{8b} \x{d0}\x{b2}\x{d0}\x{b8}\x{d0}\x{b4}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}, \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{87}\x{d0}\x{b0}\x{d1}\x{8e}\x{d1}\x{82}. \x{e2}\x{80}\x{a2} \x{d0}\x{9c}\x{d0}\x{b3}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{b4}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{bb}\x{d1}\x{8f}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d1}\x{84}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b3}\x{d1}\x{80}\x{d0}\x{b0}\x{d1}\x{84}\x{d0}\x{b8}\x{d0}\x{b8} \x{d0}\x{b8} \x{d0}\x{b3}\x{d0}\x{b8}\x{d1}\x{84}\x{d0}\x{ba}\x{d0}\x{b8} \x{d0}\x{ba} \x{d0}\x{bb}\x{d1}\x{8e}\x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{83}. \x{e2}\x{80}\x{a2} \x{d0}\x{a1}\x{d0}\x{bc}\x{d0}\x{be}\x{d1}\x{82}\x{d1}\x{80}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{84}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d1}\x{82}\x{d0}\x{b5}\x{d1}\x{85}, \x{d0}\x{ba}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bd}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8}\x{d1}\x{81}\x{d1}\x{8c} \x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8b} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}. \x{e2}\x{80}\x{a2} \x{d0}\x{91}\x{d0}\x{b5}\x{d0}\x{b7}\x{d0}\x{be}\x{d0}\x{bf}\x{d0}\x{b0}\x{d1}\x{81}\x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{8f} \x{d1}\x{81}\x{d1}\x{80}\x{d0}\x{b5}\x{d0}\x{b4}\x{d0}\x{b0}, \x{d0}\x{b2} \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d0}\x{be}\x{d0}\x{b9} \x{d0}\x{b2}\x{d1}\x{8b} \x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d1}\x{81}\x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{b4}\x{d0}\x{bd}\x{d0}\x{be} \x{d1}\x{81}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b2}\x{d1}\x{8b}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b6}\x{d0}\x{b0}\x{d1}\x{82}\x{d1}\x{8c}\x{d1}\x{81}\x{d1}\x{8f}. \x{e2}\x{80}\x{a2} \x{d0}\x{9e}\x{d1}\x{82}\x{d0}\x{ba}\x{d0}\x{bb}\x{d1}\x{8e}\x{d1}\x{87}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{be}\x{d1}\x{82} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5}\x{d1}\x{85}, \x{d0}\x{ba}\x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{bc} \x{d0}\x{bd}\x{d0}\x{b5} \x{d0}\x{bd}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b8}\x{d1}\x{82}\x{d1}\x{81}\x{d1}\x{8f}. \x{d0}\x{95}\x{d1}\x{81}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{bc}\x{d1}\x{8b} \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}? \x{d0}\x{97}\x{d0}\x{b0}\x{d1}\x{85}\x{d0}\x{be}\x{d0}\x{b4}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{bd}\x{d0}\x{b0} http://support.ask.fm \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b7}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b5}\x{d0}\x{bc} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{84}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b5}: http://ask.fm/askfmhelp. \x{d0}\x{a1}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b4}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b7}\x{d0}\x{b0} \x{d0}\x{bd}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{b8} \x{d0}\x{b2}: Instagram https://www.instagram.com/askfm/Facebook https://www.facebook.com/askfmpageTwitter https://twitter.com/askfmVKontakte https://vk.com/askfm\", \"releaseNotes\": [\"\x{d0}\x{9c}\x{d1}\x{8b} \x{d1}\x{83}\x{d1}\x{81}\x{d0}\x{b5}\x{d1}\x{80}\x{d0}\x{b4}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{bf}\x{d0}\x{be}\x{d1}\x{82}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b4}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8}\x{d1}\x{81}\x{d1}\x{8c}, \x{d1}\x{87}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b1}\x{d1}\x{8b} \x{d1}\x{81}\x{d0}\x{b4}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{b0}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} \x{d0}\x{b5}\x{d1}\x{89}\x{d0}\x{b5} \x{d0}\x{bb}\x{d1}\x{83}\x{d1}\x{87}\x{d1}\x{88}\x{d0}\x{b5}. \x{d0}\x{9d}\x{d0}\x{b5} \x{d1}\x{83}\x{d0}\x{bf}\x{d1}\x{83}\x{d1}\x{81}\x{d1}\x{82}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d1}\x{88}\x{d0}\x{b0}\x{d0}\x{bd}\x{d1}\x{81} \x{d0}\x{b7}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d1}\x{82}\x{d1}\x{8c} \x{d1}\x{81}\x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{b8} \x{d1}\x{81}\x{d0}\x{b0}\x{d0}\x{bc}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{ba}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{80}\x{d0}\x{b7}\x{d0}\x{bd}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}!\"], \"recommendation_list\": \"com.tumblr\\tco.vine.android\\tcom.weheartit\\ttv.periscope.android\\tcom.hitwe.android\\tcom.mico\\tcom.myyearbook.m\\tcom.chatous.pointblank\\tru.mail.my\\tcom.instagram.android\\tcom.oovoo\\tcom.wakie.android\\tdrug.vokrug\\tcom.tiggel.truthordareparty\\tcom.livejournal.android\\tcom.finchmil.thtclub\\tnet.lovoo.android\\tcom.sgiggle.production\\tcom.fsp.android.friendlocator\\tcom.vkontakte.android\\tru.mamba.client\\tcom.snapchat.android\\tcom.keek\\tcom.social.ask.fm.sprashivai\\tru.ok.android\\tcom.socialshareup.kikshareup\\tcom.chat.ruletka\\tcom.nintendo.zaaa\\tcom.linkedin.android\\tcom.pinterest\\tru.sprashivai\\tcom.fsp.android.c\\tcom.airg.hookt\\tnet.newsoftwares.SocialMediaVault\\tru.ideer.android\\tcom.path\\tcom.findmillionaire.android\\tcom.vsetiby.vs\\tcom.k12andriod.haha\\tchat.meet.date.me\\tcom.waplogmatch.social\\tcom.hootsuite.droid.full\\tcom.emoji.ikeyboard.theme.Sakura\\tcom.smsbox.love_box\\tcom.VEEMEE.VME\\tcom.marcow.birthdaylist\\tcom.a13.status\\tcom.creaio.coolstories\\tru.advance.revizona\\tcom.buddypoke.buddypoke\", \"icon_ex\": {\"imagename\": \"0bb5cbb5b263d795679f55c0c5609d55\", \"meta\": {\"ColorWizText\": \"#F3C2CB\", \"orig-size\": {\"y\": 512, \"x\": 512}, \"orig-format\": \"PNG\", \"processed_by_computer_vision\": \"true\", \"processing\": \"finished\", \"r-orig-size\": {\"y\": 512, \"x\": 512}, \"ColorWizButtonText\": \"#E67589\", \"ColorWizButton\": \"#DA3E59\", \"ColorWizBack\": \"#D83450\", \"MainColor\": \"#D83050\", \"orig-orientation\": \"\", \"AverageBorderColor\": \"#D83450\", \"md5\": \"73af054abdf2810dc9dd2cd81bffc799\"}, \"group-id\": 40210, \"sizes\": {\"icon-s\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-s\", \"width\": 16, \"height\": 16}, \"icon-xxxhdi\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-xxxhdi\", \"width\": 192, \"height\": 192}, \"icon-xld-retina\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-xld-retina\", \"width\": 300, \"height\": 300}, \"icon-ldd\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-ldd\", \"width\": 90, \"height\": 90}, \"icon-ld\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-ld\", \"width\": 80, \"height\": 80}, \"icon-xl\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-xl\", \"width\": 144, \"height\": 144}, \"orig\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/orig\", \"width\": 512, \"height\": 512}, \"icon-s-retina\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-s-retina\", \"width\": 32, \"height\": 32}, \"icon-xhdpi\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-xhdpi\", \"width\": 96, \"height\": 96}, \"icon-xld\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-xld\", \"width\": 150, \"height\": 150}, \"icon-mdpi\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-mdpi\", \"width\": 48, \"height\": 48}, \"icon-ld-retina\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-ld-retina\", \"width\": 160, \"height\": 160}, \"icon\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon\", \"width\": 65, \"height\": 65}, \"icon-lr\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-lr\", \"width\": 72, \"height\": 72}, \"icon-l\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-l\", \"width\": 72, \"height\": 72}, \"icon-ldd-retina\": {\"path\": \"/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/icon-ldd-retina\", \"width\": 180, \"height\": 180}}}, \"adult\": \"12+\", \"categories\": [\"APPLICATION\"], \"icon\": \"http://avatars.mds.yandex.net/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/orig\", \"name\": \"ASKfm - \x{d0}\x{97}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}\", \"subcategory_eng\": [\"SOCIAL\"], \"reviews\": [{\"rating\": \"4\", \"author\": \"\", \"title\": \"\", \"text\": \"\x{d0}\x{98} \x{d1}\x{82}\x{d0}\x{b0}\x{d0}\x{ba}, \x{d0}\x{b2}\x{d1}\x{81}\x{d1}\x{91} \x{d0}\x{bd}\x{d0}\x{be}\x{d1}\x{80}\x{d0}\x{bc}\x{d0}\x{b0}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{bd}\x{d0}\x{be}. \x{d0}\x{af} \x{d1}\x{81}\x{d1}\x{82}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{bb}\x{d1}\x{8e} 4 \x{d0}\x{b7}\x{d0}\x{b2}\x{d0}\x{b5}\x{d0}\x{b7}\x{d0}\x{b4}\x{d1}\x{8b} \x{d0}\x{bf}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d1}\x{87}\x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{b5} \x{d0}\x{bd}\x{d0}\x{b5} \x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b8}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{b1}\x{d1}\x{8b}\x{d0}\x{bb}\x{d0}\x{be} \x{d1}\x{83}\x{d0}\x{b2}\x{d0}\x{b8}\x{d0}\x{b4}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8b} \x{d0}\x{b8} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d1}\x{8d}\x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b5}\x{d0}\x{b9} \x{d1}\x{81}\x{d1}\x{82}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{b8}\x{d1}\x{86}\x{d0}\x{b5} \x{d0}\x{92}\x{d0}\x{9a}!!\", \"date_ts\": \"1517259600\", \"date\": \"30 \x{d1}\x{8f}\x{d0}\x{bd}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{80}\x{d1}\x{8f} 2018 \x{d0}\x{b3}.\", \"authorlink\": \"https://play.google.com\"}, {\"rating\": \"5\", \"author\": \"\", \"title\": \"\", \"text\": \"\x{d0}\x{bd}\x{d0}\x{b5}\x{d0}\x{b7}\x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{8e}\", \"date_ts\": \"1517259600\", \"date\": \"30 \x{d1}\x{8f}\x{d0}\x{bd}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{80}\x{d1}\x{8f} 2018 \x{d0}\x{b3}.\", \"authorlink\": \"https://play.google.com\"}, {\"rating\": \"3\", \"author\": \"\x{d0}\x{90}\x{d0}\x{bd}\x{d0}\x{b4}\x{d1}\x{80}\x{d0}\x{b5}\x{d0}\x{b9} \x{d0}\x{a6}\x{d1}\x{86}\", \"title\": \"\", \"text\": \"\x{d0}\x{9c}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d1}\x{82} \x{d0}\x{b8} \x{d0}\x{bd}\x{d0}\x{b5}\x{d0}\x{bf}\x{d0}\x{bb}\x{d0}\x{be}\x{d1}\x{85}\x{d0}\x{be} - \x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{b2}\x{d0}\x{b7}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d0}\x{bb}\x{d1}\x{8b}\x{d0}\x{bc} \x{d0}\x{ba}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d0}\x{b7}\x{d0}\x{b0} 30 \x{d1}\x{82}\x{d0}\x{b0}\x{d0}\x{bc} \x{d0}\x{b4}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{b0}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{bd}\x{d0}\x{b5}\x{d1}\x{84}\x{d0}\x{b8}\x{d0}\x{b3}!  \x{d0}\x{9e}\x{d0}\x{b4}\x{d0}\x{b0} \x{d1}\x{88}\x{d0}\x{bf}\x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{b0} !\", \"date_ts\": \"1517259600\", \"date\": \"30 \x{d1}\x{8f}\x{d0}\x{bd}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{80}\x{d1}\x{8f} 2018 \x{d0}\x{b3}.\", \"authorlink\": \"https://play.google.com\"}, {\"rating\": \"4\", \"author\": \"\x{d0}\x{91}\x{d0}\x{b5}\x{d0}\x{b7} \x{d0}\x{98}\x{d0}\x{bc}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\", \"title\": \"\", \"text\": \"\x{d0}\x{92}\x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bb}\x{d0}\x{bd}\x{d0}\x{b5} \x{d1}\x{85}\x{d0}\x{be}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{88}\x{d0}\x{be}\", \"date_ts\": \"1517259600\", \"date\": \"30 \x{d1}\x{8f}\x{d0}\x{bd}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{80}\x{d1}\x{8f} 2018 \x{d0}\x{b3}.\", \"authorlink\": \"https://play.google.com\"}, {\"rating\": \"5\", \"author\": \"\", \"title\": \"\", \"text\": \"\x{d0}\x{92} \x{d1}\x{86}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{bc}, \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{b8}\x{d0}\x{ba}\x{d0}\x{be}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{bf}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b5}. \x{d0}\x{9d}\x{d0}\x{b8}\x{d0}\x{ba}\x{d0}\x{b0}\x{d0}\x{ba}\x{d0}\x{b8}\x{d1}\x{85} \x{d0}\x{b1}\x{d0}\x{b0}\x{d0}\x{b3}\x{d0}\x{be}\x{d0}\x{b2}, \x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b6}\x{d0}\x{b5} \x{d0}\x{b5}\x{d1}\x{81}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b5}\x{d1}\x{81}\x{d1}\x{82}\x{d1}\x{8c} \x{d1}\x{80}\x{d0}\x{b5}\x{d0}\x{ba}\x{d0}\x{bb}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{b0}, \x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{b5}\x{d1}\x{91} \x{d0}\x{bd}\x{d0}\x{b5} \x{d1}\x{81}\x{d0}\x{b8}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b3}\x{d0}\x{be}. \x{d0}\x{95}\x{d0}\x{b4}\x{d0}\x{b8}\x{d0}\x{bd}\x{d1}\x{81}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{bd}\x{d1}\x{8b}\x{d0}\x{b9} \x{d0}\x{bc}\x{d0}\x{b8}\x{d0}\x{bd}\x{d1}\x{83}\x{d1}\x{81}, \x{d1}\x{8d}\x{d1}\x{82}\x{d0}\x{be} \x{d1}\x{82}\x{d0}\x{be}, \x{d1}\x{87}\x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{bd}\x{d0}\x{b5}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{b7}\x{d1}\x{8f} \x{d1}\x{81}\x{d0}\x{bc}\x{d0}\x{be}\x{d1}\x{82}\x{d1}\x{80}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8c} \x{d1}\x{81}\x{d0}\x{bf}\x{d0}\x{b8}\x{d1}\x{81}\x{d0}\x{be}\x{d0}\x{ba} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{b4}\x{d0}\x{bf}\x{d0}\x{b8}\x{d1}\x{81}\x{d1}\x{87}\x{d0}\x{b8}\x{d0}\x{ba}\x{d0}\x{be}\x{d0}\x{b2}. \x{d0}\x{94}\x{d0}\x{be}\x{d1}\x{80}\x{d0}\x{be}\x{d0}\x{b3}\x{d0}\x{b8}\x{d0}\x{b5} \x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b7}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b1}\x{d0}\x{be}\x{d1}\x{82}\x{d1}\x{87}\x{d0}\x{b8}\x{d0}\x{ba}\x{d0}\x{b8}, \x{d0}\x{b4}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{b0}\x{d0}\x{b2}\x{d1}\x{8c}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b0}\x{d0}\x{bb}\x{d1}\x{83}\x{d0}\x{b9}\x{d1}\x{81}\x{d1}\x{82}\x{d0}\x{b0} \x{d1}\x{80}\x{d0}\x{b5}\x{d1}\x{88}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} \x{d1}\x{8d}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b3}\x{d0}\x{be} \x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{bc}\x{d0}\x{b5}\x{d0}\x{bd}\x{d1}\x{82}\x{d0}\x{b0} \x{d0}\x{b2} \x{d1}\x{81}\x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{b8} \x{d0}\x{bf}\x{d0}\x{bb}\x{d0}\x{b0}\x{d0}\x{bd}\x{d1}\x{8b}, \x{d0}\x{b1}\x{d1}\x{83}\x{d0}\x{b4}\x{d1}\x{83} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{b7}\x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{82}\x{d0}\x{b5}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{bd}\x{d0}\x{b0})\", \"date_ts\": \"1517259600\", \"date\": \"30 \x{d1}\x{8f}\x{d0}\x{bd}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{80}\x{d1}\x{8f} 2018 \x{d0}\x{b3}.\", \"authorlink\": \"https://play.google.com\"}, {\"rating\": \"5\", \"author\": \"Nastya Yakusheva\", \"title\": \"\", \"text\": \"\x{d0}\x{92}\x{d0}\x{b0}\x{d1}\x{83}\", \"date_ts\": \"1517259600\", \"date\": \"30 \x{d1}\x{8f}\x{d0}\x{bd}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{80}\x{d1}\x{8f} 2018 \x{d0}\x{b3}.\", \"authorlink\": \"https://play.google.com\"}, {\"rating\": \"5\", \"author\": \"\x{d0}\x{9a}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{b0}\x{d0}\x{b7} \x{d0}\x{92}\x{d0}\x{b0}\x{d0}\x{b3}\x{d0}\x{b5}\x{d0}\x{bd}\", \"title\": \"\", \"text\": \"\x{d0}\x{9f}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{bb}\x{d0}\x{b8}\x{d1}\x{87}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b5} \x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{b1}\x{d1}\x{8b}\x{d0}\x{bb}\x{d0}\x{be} \x{d0}\x{b1}\x{d1}\x{8b} \x{d0}\x{b4}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b8}\x{d1}\x{82}\x{d1}\x{8c} \x{d1}\x{87}\x{d1}\x{82}\x{d0}\x{be} \x{d1}\x{82}\x{d0}\x{be} \x{d1}\x{82}\x{d0}\x{b8}\x{d0}\x{bf}\x{d0}\x{be} \x{d0}\x{b4}\x{d0}\x{b8}\x{d1}\x{80}\x{d0}\x{b5}\x{d0}\x{ba}\x{d1}\x{82}\x{d0}\x{b0})))\", \"date_ts\": \"1517259600\", \"date\": \"30 \x{d1}\x{8f}\x{d0}\x{bd}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{80}\x{d1}\x{8f} 2018 \x{d0}\x{b3}.\", \"authorlink\": \"https://play.google.com\"}, {\"rating\": \"4\", \"author\": \"\", \"title\": \"\", \"text\": \"\x{d0}\x{a5}\x{d0}\x{be}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{88}\x{d0}\x{be} \x{d0}\x{bd}\x{d0}\x{be} \x{d1}\x{82}\x{d0}\x{b5}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{be} \x{d0}\x{bd}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b8} \x{d0}\x{ba}\x{d0}\x{be}\x{d0}\x{b3}\x{d0}\x{be} \x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b1}\x{d1}\x{83}\x{d1}\x{82}\x{d1}\x{8c}\", \"date_ts\": \"1517259600\", \"date\": \"30 \x{d1}\x{8f}\x{d0}\x{bd}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{80}\x{d1}\x{8f} 2018 \x{d0}\x{b3}.\", \"authorlink\": \"https://play.google.com\"}, {\"rating\": \"5\", \"author\": \"\", \"title\": \"\", \"text\": \"\x{d0}\x{b7}\x{d0}\x{b0}\x{d1}\x{87}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{8f} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d0}\x{b3}\x{d0}\x{b0}\", \"date_ts\": \"1517259600\", \"date\": \"30 \x{d1}\x{8f}\x{d0}\x{bd}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{80}\x{d1}\x{8f} 2018 \x{d0}\x{b3}.\", \"authorlink\": \"https://play.google.com\"}, {\"rating\": \"5\", \"author\": \"\", \"title\": \"\", \"text\": \"\x{d0}\x{a5}\x{d0}\x{be}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{88}\x{d0}\x{b5}\x{d0}\x{b5} \x{d0}\x{b8} \x{d1}\x{83}\x{d0}\x{b4}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b5} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d1}\x{83}. \x{d0}\x{92}\x{d1}\x{81}\x{d0}\x{b5}\x{d0}\x{bc} \x{d1}\x{81}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{83}\x{d1}\x{8e}\", \"date_ts\": \"1517173200\", \"date\": \"29 \x{d1}\x{8f}\x{d0}\x{bd}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{80}\x{d1}\x{8f} 2018 \x{d0}\x{b3}.\", \"authorlink\": \"https://play.google.com\"}], \"screens_ex\": [{\"extra\": {\"svg\": {\"path\": \"/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/svg\"}}, \"imagename\": \"12cb6efcae69697bb22441432c55659c\", \"meta\": {\"orig-size\": {\"y\": 2048, \"x\": 1200}, \"orig-format\": \"PNG\", \"processed_by_computer_vision\": true, \"processing\": \"finished\", \"r-orig-size\": {\"y\": 1400, \"x\": 820}, \"SmartCrop\": {\"320x240\": {\"FitLevel\": 0.824311, \"Rect\": [42, 435, 1158, 869]}, \"160x120\": {\"FitLevel\": 0.822918, \"Rect\": [70, 442, 1130, 847]}}, \"crc64\": \"7A8A8FD6B5EB2B80\", \"MainColor\": \"#F86048\", \"orig-orientation\": \"\", \"md5\": \"ccb766da9a41756e52504ee7f60741de\"}, \"group-id\": 114777, \"sizes\": {\"gallery_crop\": {\"path\": \"/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/gallery_crop\", \"height\": 120, \"width\": 160}, \"gallery_retina\": {\"path\": \"/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/gallery_retina\", \"height\": 240, \"width\": 141}, \"gallery_retina_crop\": {\"path\": \"/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/gallery_retina_crop\", \"height\": 240, \"width\": 320}, \"preview\": {\"path\": \"/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/preview\", \"height\": 320, \"width\": 188}, \"gallery\": {\"path\": \"/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/gallery\", \"height\": 120, \"width\": 70}, \"orig\": {\"path\": \"/get-google-play-app-screens/114777/12cb6efcae69697bb22441432c55659c/orig\", \"height\": 2048, \"width\": 1200}}}, {\"extra\": {\"svg\": {\"path\": \"/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/svg\"}}, \"imagename\": \"7fc68f1d9c82a3846328bea6d655f0de\", \"meta\": {\"orig-size\": {\"y\": 2048, \"x\": 1200}, \"orig-format\": \"PNG\", \"processed_by_computer_vision\": true, \"processing\": \"finished\", \"r-orig-size\": {\"y\": 1400, \"x\": 820}, \"SmartCrop\": {\"320x240\": {\"FitLevel\": 0.73259, \"Rect\": [0, 544, 1200, 901]}, \"160x120\": {\"FitLevel\": 0.728599, \"Rect\": [0, 521, 1200, 900]}}, \"crc64\": \"4452552E4EE467F6\", \"MainColor\": \"#484850\", \"orig-orientation\": \"\", \"md5\": \"ec831948317c87ab7c2fcd787467dc60\"}, \"group-id\": 466137, \"sizes\": {\"gallery_crop\": {\"path\": \"/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/gallery_crop\", \"height\": 120, \"width\": 160}, \"gallery_retina\": {\"path\": \"/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/gallery_retina\", \"height\": 240, \"width\": 141}, \"gallery_retina_crop\": {\"path\": \"/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/gallery_retina_crop\", \"height\": 240, \"width\": 320}, \"preview\": {\"path\": \"/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/preview\", \"height\": 320, \"width\": 188}, \"gallery\": {\"path\": \"/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/gallery\", \"height\": 120, \"width\": 70}, \"orig\": {\"path\": \"/get-google-play-app-screens/466137/7fc68f1d9c82a3846328bea6d655f0de/orig\", \"height\": 2048, \"width\": 1200}}}, {\"extra\": {\"svg\": {\"path\": \"/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/svg\"}}, \"imagename\": \"100834736c36e9e9aaea4837076ba04d\", \"meta\": {\"orig-size\": {\"y\": 2048, \"x\": 1200}, \"orig-format\": \"PNG\", \"processed_by_computer_vision\": true, \"processing\": \"finished\", \"r-orig-size\": {\"y\": 1400, \"x\": 820}, \"SmartCrop\": {\"320x240\": {\"FitLevel\": 0.867031, \"Rect\": [0, 840, 1200, 900]}, \"160x120\": {\"FitLevel\": 0.874548, \"Rect\": [0, 773, 1200, 901]}}, \"crc64\": \"EC9A73B82C988065\", \"MainColor\": \"#C03048\", \"orig-orientation\": \"\", \"md5\": \"85c94914461cc3d8ce6a5b4f7ea7b062\"}, \"group-id\": 466137, \"sizes\": {\"gallery_crop\": {\"path\": \"/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/gallery_crop\", \"height\": 120, \"width\": 160}, \"gallery_retina\": {\"path\": \"/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/gallery_retina\", \"height\": 240, \"width\": 141}, \"gallery_retina_crop\": {\"path\": \"/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/gallery_retina_crop\", \"height\": 240, \"width\": 320}, \"preview\": {\"path\": \"/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/preview\", \"height\": 320, \"width\": 188}, \"gallery\": {\"path\": \"/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/gallery\", \"height\": 120, \"width\": 70}, \"orig\": {\"path\": \"/get-google-play-app-screens/466137/100834736c36e9e9aaea4837076ba04d/orig\", \"height\": 2048, \"width\": 1200}}}, {\"extra\": {\"svg\": {\"path\": \"/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/svg\"}}, \"imagename\": \"1d650cb1a9df34438fab4ce92ca8e609\", \"meta\": {\"orig-size\": {\"y\": 2048, \"x\": 1200}, \"orig-format\": \"PNG\", \"processed_by_computer_vision\": true, \"processing\": \"finished\", \"r-orig-size\": {\"y\": 1400, \"x\": 820}, \"SmartCrop\": {\"320x240\": {\"FitLevel\": 0.942118, \"Rect\": [0, 713, 1200, 901]}, \"160x120\": {\"FitLevel\": 0.942309, \"Rect\": [0, 689, 1200, 900]}}, \"crc64\": \"4C73D9C2E8007E51\", \"MainColor\": \"#582050\", \"orig-orientation\": \"\", \"md5\": \"26846be78d0bae023f9dee560398d48d\"}, \"group-id\": 218654, \"sizes\": {\"gallery_crop\": {\"path\": \"/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/gallery_crop\", \"height\": 120, \"width\": 160}, \"gallery_retina\": {\"path\": \"/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/gallery_retina\", \"height\": 240, \"width\": 141}, \"gallery_retina_crop\": {\"path\": \"/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/gallery_retina_crop\", \"height\": 240, \"width\": 320}, \"preview\": {\"path\": \"/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/preview\", \"height\": 320, \"width\": 188}, \"gallery\": {\"path\": \"/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/gallery\", \"height\": 120, \"width\": 70}, \"orig\": {\"path\": \"/get-google-play-app-screens/218654/1d650cb1a9df34438fab4ce92ca8e609/orig\", \"height\": 2048, \"width\": 1200}}}, {\"extra\": {\"svg\": {\"path\": \"/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/svg\"}}, \"imagename\": \"6d542729c612938b2890834740af4e5e\", \"meta\": {\"orig-size\": {\"y\": 2048, \"x\": 1200}, \"orig-format\": \"PNG\", \"processed_by_computer_vision\": true, \"processing\": \"finished\", \"r-orig-size\": {\"y\": 1400, \"x\": 820}, \"SmartCrop\": {\"320x240\": {\"FitLevel\": 0.624049, \"Rect\": [0, 82, 1200, 901]}, \"160x120\": {\"FitLevel\": 0.622303, \"Rect\": [0, 59, 1200, 900]}}, \"crc64\": \"E617D690640E02B4\", \"MainColor\": \"#28C0D0\", \"orig-orientation\": \"\", \"md5\": \"a620fd3c8aaafd172fa6c9763e804902\"}, \"group-id\": 403753, \"sizes\": {\"gallery_crop\": {\"path\": \"/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/gallery_crop\", \"height\": 120, \"width\": 160}, \"gallery_retina\": {\"path\": \"/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/gallery_retina\", \"height\": 240, \"width\": 141}, \"gallery_retina_crop\": {\"path\": \"/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/gallery_retina_crop\", \"height\": 240, \"width\": 320}, \"preview\": {\"path\": \"/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/preview\", \"height\": 320, \"width\": 188}, \"gallery\": {\"path\": \"/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/gallery\", \"height\": 120, \"width\": 70}, \"orig\": {\"path\": \"/get-google-play-app-screens/403753/6d542729c612938b2890834740af4e5e/orig\", \"height\": 2048, \"width\": 1200}}}]}",
                                        'TextBM25'                       => ['0.5',      '0.5',      '0.5'],
                                        'rating_value'                   => ['0.821399', '0.821399', '0.821399'],
                                        'LongClickBocmPlain'             => ['0',        '0',        '0'],
                                        'price'                          => '0',
                                        'QueryDwellTimeBm15CoverageV4K3' => ['0',        '0',        '0'],
                                        'icon' =>
'http://avatars.mds.yandex.net/get-google-play-app-icon/40210/0bb5cbb5b263d795679f55c0c5609d55/orig',
                                        'Bclm' => ['0', '0', '0'],
                                        'html_description' =>
"\x{d0}\x{91}\x{d0}\x{be}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b5} 215\x{c2}\x{a0}\x{d0}\x{bc}\x{d0}\x{bb}\x{d0}\x{bd} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{b7}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{82}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b9} \x{d0}\x{bb}\x{d1}\x{8e}\x{d0}\x{b1}\x{d1}\x{8f}\x{d1}\x{82} ASKfm! ASKfm\x{c2}\x{a0}\x{e2}\x{80}\x{93} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} \x{e2}\x{84}\x{96}\x{c2}\x{a0}1 \x{d0}\x{b4}\x{d0}\x{bb}\x{d1}\x{8f} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d0}\x{be}\x{d0}\x{b2} \x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b2}, \x{d0}\x{b3}\x{d0}\x{b4}\x{d0}\x{b5} \x{d0}\x{b2}\x{d1}\x{8b} \x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d1}\x{83}\x{d0}\x{b7}\x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{8c}\x{d1}\x{88}\x{d0}\x{b5} \x{d0}\x{be} \x{d1}\x{81}\x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{b8}\x{d1}\x{85} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b7}\x{d1}\x{8c}\x{d1}\x{8f}\x{d1}\x{85}, \x{d0}\x{b7}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{8f} \x{d0}\x{b8}\x{d0}\x{bc} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{b8} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{83}\x{d1}\x{87}\x{d0}\x{b0}\x{d1}\x{8f} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8b}. \x{d0}\x{a1}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b8}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{ba}\x{d0}\x{b0}\x{d0}\x{ba} \x{d1}\x{85}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5}\x{c2}\x{a0}\x{e2}\x{80}\x{93} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{bd}\x{d0}\x{b5}\x{d1}\x{82}. \x{d0}\x{ad}\x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{81}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{be} \x{d0}\x{b8} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{82}\x{d0}\x{be}, \x{d0}\x{b8} \x{d0}\x{b2}\x{d1}\x{8b} \x{d0}\x{bd}\x{d0}\x{b5} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{80}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5}, \x{d0}\x{ba}\x{d0}\x{b0}\x{d0}\x{ba} \x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b3}\x{d0}\x{be} \x{d0}\x{b2}\x{d1}\x{8b} \x{d1}\x{83}\x{d0}\x{b7}\x{d0}\x{bd}\x{d0}\x{b0}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{be} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b3}\x{d0}\x{b8}\x{d1}\x{85} \x{d0}\x{b8} \x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b6}\x{d0}\x{b5} \x{d0}\x{be} \x{d1}\x{81}\x{d0}\x{b5}\x{d0}\x{b1}\x{d0}\x{b5}! <br>\x{d0}\x{9a}\x{d0}\x{b0}\x{d0}\x{b6}\x{d0}\x{b4}\x{d1}\x{8b}\x{d0}\x{b9} \x{d0}\x{b4}\x{d0}\x{b5}\x{d0}\x{bd}\x{d1}\x{8c} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{b7}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{82}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{b8} ASKfm \x{d0}\x{b2}\x{d0}\x{be} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5}\x{d0}\x{bc} \x{d0}\x{bc}\x{d0}\x{b8}\x{d1}\x{80}\x{d0}\x{b5} \x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{bc}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{8e}\x{d1}\x{82}\x{d1}\x{81}\x{d1}\x{8f} \x{d0}\x{bc}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{bb}\x{d0}\x{b8}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{b8} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d0}\x{be}\x{d0}\x{b2} \x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b2} \x{d0}\x{bd}\x{d0}\x{b0} 40 \x{d1}\x{81} \x{d0}\x{bb}\x{d0}\x{b8}\x{d1}\x{88}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc} \x{d1}\x{8f}\x{d0}\x{b7}\x{d1}\x{8b}\x{d0}\x{ba}\x{d0}\x{b0}\x{d1}\x{85}. \x{d0}\x{9e}\x{d1}\x{82}\x{d0}\x{ba}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b2} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5}, \x{d0}\x{b2}\x{d1}\x{8b} \x{d1}\x{83}\x{d0}\x{b2}\x{d0}\x{b8}\x{d0}\x{b4}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}, \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b8} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b7}\x{d1}\x{8c}\x{d1}\x{8f}, \x{d0}\x{b8} \x{d1}\x{81}\x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b8}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}, \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{b1}\x{d1}\x{8b}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d1}\x{81}\x{d0}\x{bb}\x{d0}\x{b0}\x{d0}\x{bd}\x{d1}\x{8b} \x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{bc}. \x{d0}\x{92}\x{d0}\x{be}\x{d1}\x{82} \x{d1}\x{87}\x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b5}\x{d0}\x{b4}\x{d0}\x{bb}\x{d0}\x{b0}\x{d0}\x{b3}\x{d0}\x{b0}\x{d0}\x{b5}\x{d1}\x{82} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} ASKfm:<br><br>  \x{e2}\x{80}\x{a2} \x{d0}\x{97}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{bb}\x{d1}\x{8e}\x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b3}\x{d1}\x{83}\x{c2}\x{a0}\x{e2}\x{80}\x{93} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{bd}\x{d0}\x{b5}\x{d1}\x{82}.<br>  \x{e2}\x{80}\x{a2} \x{d0}\x{9f}\x{d0}\x{be}\x{d0}\x{b4}\x{d0}\x{bf}\x{d0}\x{b8}\x{d1}\x{81}\x{d1}\x{8b}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5}\x{d1}\x{81}\x{d1}\x{8c} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b7}\x{d0}\x{b5}\x{d0}\x{b9}, \x{d1}\x{87}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b1}\x{d1}\x{8b} \x{d0}\x{b2}\x{d0}\x{b8}\x{d0}\x{b4}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}, \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{87}\x{d0}\x{b0}\x{d1}\x{8e}\x{d1}\x{82}. <br>  \x{e2}\x{80}\x{a2} \x{d0}\x{9c}\x{d0}\x{b3}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{b4}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{bb}\x{d1}\x{8f}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d1}\x{84}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b3}\x{d1}\x{80}\x{d0}\x{b0}\x{d1}\x{84}\x{d0}\x{b8}\x{d0}\x{b8} \x{d0}\x{b8} \x{d0}\x{b3}\x{d0}\x{b8}\x{d1}\x{84}\x{d0}\x{ba}\x{d0}\x{b8} \x{d0}\x{ba} \x{d0}\x{bb}\x{d1}\x{8e}\x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{83}.<br>  \x{e2}\x{80}\x{a2} \x{d0}\x{a1}\x{d0}\x{bc}\x{d0}\x{be}\x{d1}\x{82}\x{d1}\x{80}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{84}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d1}\x{82}\x{d0}\x{b5}\x{d1}\x{85}, \x{d0}\x{ba}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bd}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8}\x{d1}\x{81}\x{d1}\x{8c} \x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8b} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}.<br>  \x{e2}\x{80}\x{a2} \x{d0}\x{91}\x{d0}\x{b5}\x{d0}\x{b7}\x{d0}\x{be}\x{d0}\x{bf}\x{d0}\x{b0}\x{d1}\x{81}\x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{8f} \x{d1}\x{81}\x{d1}\x{80}\x{d0}\x{b5}\x{d0}\x{b4}\x{d0}\x{b0}, \x{d0}\x{b2} \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d0}\x{be}\x{d0}\x{b9} \x{d0}\x{b2}\x{d1}\x{8b} \x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d1}\x{81}\x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{b4}\x{d0}\x{bd}\x{d0}\x{be} \x{d1}\x{81}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b2}\x{d1}\x{8b}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b6}\x{d0}\x{b0}\x{d1}\x{82}\x{d1}\x{8c}\x{d1}\x{81}\x{d1}\x{8f}. <br>  \x{e2}\x{80}\x{a2} \x{d0}\x{9e}\x{d1}\x{82}\x{d0}\x{ba}\x{d0}\x{bb}\x{d1}\x{8e}\x{d1}\x{87}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{be}\x{d1}\x{82} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5}\x{d1}\x{85}, \x{d0}\x{ba}\x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{bc} \x{d0}\x{bd}\x{d0}\x{b5} \x{d0}\x{bd}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b8}\x{d1}\x{82}\x{d1}\x{81}\x{d1}\x{8f}. <br><br>\x{d0}\x{95}\x{d1}\x{81}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{bc}\x{d1}\x{8b} \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}? \x{d0}\x{97}\x{d0}\x{b0}\x{d1}\x{85}\x{d0}\x{be}\x{d0}\x{b4}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{bd}\x{d0}\x{b0} http://support.ask.fm \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b7}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b5}\x{d0}\x{bc} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{84}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b5}: http://ask.fm/askfmhelp. <br><br>\x{d0}\x{a1}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b4}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b7}\x{d0}\x{b0} \x{d0}\x{bd}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{b8} \x{d0}\x{b2}: <br>Instagram https://www.instagram.com/askfm/<br>Facebook https://www.facebook.com/askfmpage<br>Twitter https://twitter.com/askfm<br>VKontakte https://vk.com/askfm",
                                        'app_id'    => 'com.askfm',
                                        'TxtBm25Ex' => ['0.5', '0.5', '0.5'],
                                        'description_small' =>
"\x{d0}\x{91}\x{d0}\x{be}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b5} 215 \x{d0}\x{bc}\x{d0}\x{bb}\x{d0}\x{bd} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{b7}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{82}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b9} \x{d0}\x{bb}\x{d1}\x{8e}\x{d0}\x{b1}\x{d1}\x{8f}\x{d1}\x{82} ASKfm! ASKfm \x{e2}\x{80}\x{93} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} \x{e2}\x{84}\x{96} 1 \x{d0}\x{b4}\x{d0}\x{bb}\x{d1}\x{8f} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d0}\x{be}\x{d0}\x{b2} \x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b2}, \x{d0}\x{b3}\x{d0}\x{b4}\x{d0}\x{b5} \x{d0}\x{b2}\x{d1}\x{8b} \x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d1}\x{83}\x{d0}\x{b7}\x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{8c}\x{d1}\x{88}\x{d0}\x{b5} \x{d0}\x{be} \x{d1}\x{81}\x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{b8}\x{d1}\x{85} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b7}\x{d1}\x{8c}\x{d1}\x{8f}\x{d1}\x{85}, \x{d0}\x{b7}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{8f} \x{d0}\x{b8}\x{d0}\x{bc} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{b8} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{83}\x{d1}\x{87}\x{d0}\x{b0}\x{d1}\x{8f} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8b}. \x{d0}\x{a1}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b8}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{ba}\x{d0}\x{b0}\x{d0}\x{ba} \x{d1}\x{85}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{e2}\x{80}\x{93} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{bd}\x{d0}\x{b5}\x{d1}\x{82}. \x{d0}\x{ad}\x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{81}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{be} \x{d0}\x{b8} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{82}\x{d0}\x{be}, \x{d0}\x{b8} \x{d0}\x{b2}\x{d1}\x{8b} \x{d0}\x{bd}\x{d0}\x{b5} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{80}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5}, \x{d0}\x{ba}\x{d0}\x{b0}\x{d0}\x{ba} \x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b3}\x{d0}\x{be} \x{d0}\x{b2}\x{d1}\x{8b} \x{d1}\x{83}\x{d0}\x{b7}\x{d0}\x{bd}\x{d0}\x{b0}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{be} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b3}\x{d0}\x{b8}\x{d1}\x{85} \x{d0}\x{b8} \x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b6}\x{d0}\x{b5} \x{d0}\x{be} \x{d1}\x{81}\x{d0}\x{b5}\x{d0}\x{b1}\x{d0}\x{b5}! \x{d0}\x{9a}\x{d0}\x{b0}\x{d0}\x{b6}\x{d0}\x{b4}\x{d1}\x{8b}\x{d0}\x{b9} \x{d0}\x{b4}\x{d0}\x{b5}\x{d0}\x{bd}\x{d1}\x{8c} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bb}\x{d1}\x{8c}\x{d0}\x{b7}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{82}\x{d0}\x{b5}\x{d0}\x{bb}\x{d0}\x{b8} ASKfm \x{d0}\x{b2}\x{d0}\x{be} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5}\x{d0}\x{bc} \x{d0}\x{bc}\x{d0}\x{b8}\x{d1}\x{80}\x{d0}\x{b5} \x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{bc}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{8e}\x{d1}\x{82}\x{d1}\x{81}\x{d1}\x{8f} \x{d0}\x{bc}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{bb}\x{d0}\x{b8}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{b8} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d0}\x{be}\x{d0}\x{b2} \x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b2} \x{d0}\x{bd}\x{d0}\x{b0} 40 \x{d1}\x{81} \x{d0}\x{bb}\x{d0}\x{b8}\x{d1}\x{88}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc} \x{d1}\x{8f}\x{d0}\x{b7}\x{d1}\x{8b}\x{d0}\x{ba}\x{d0}\x{b0}\x{d1}\x{85}. \x{d0}\x{9e}\x{d1}\x{82}\x{d0}\x{ba}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b2} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5}, \x{d0}\x{b2}\x{d1}\x{8b} \x{d1}\x{83}\x{d0}\x{b2}\x{d0}\x{b8}\x{d0}\x{b4}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}, \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b8} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b7}\x{d1}\x{8c}\x{d1}\x{8f}, \x{d0}\x{b8} \x{d1}\x{81}\x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b8}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}, \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{b1}\x{d1}\x{8b}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d1}\x{81}\x{d0}\x{bb}\x{d0}\x{b0}\x{d0}\x{bd}\x{d1}\x{8b} \x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{bc}. \x{d0}\x{92}\x{d0}\x{be}\x{d1}\x{82} \x{d1}\x{87}\x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b5}\x{d0}\x{b4}\x{d0}\x{bb}\x{d0}\x{b0}\x{d0}\x{b3}\x{d0}\x{b0}\x{d0}\x{b5}\x{d1}\x{82} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{b5} ASKfm: \x{e2}\x{80}\x{a2} \x{d0}\x{97}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{bb}\x{d1}\x{8e}\x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b3}\x{d1}\x{83} \x{e2}\x{80}\x{93} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{bd}\x{d0}\x{b5}\x{d1}\x{82}. \x{e2}\x{80}\x{a2} \x{d0}\x{9f}\x{d0}\x{be}\x{d0}\x{b4}\x{d0}\x{bf}\x{d0}\x{b8}\x{d1}\x{81}\x{d1}\x{8b}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5}\x{d1}\x{81}\x{d1}\x{8c} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{b4}\x{d1}\x{80}\x{d1}\x{83}\x{d0}\x{b7}\x{d0}\x{b5}\x{d0}\x{b9}, \x{d1}\x{87}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b1}\x{d1}\x{8b} \x{d0}\x{b2}\x{d0}\x{b8}\x{d0}\x{b4}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}, \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{87}\x{d0}\x{b0}\x{d1}\x{8e}\x{d1}\x{82}. \x{e2}\x{80}\x{a2} \x{d0}\x{9c}\x{d0}\x{b3}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{b2}\x{d0}\x{b5}\x{d0}\x{bd}\x{d0}\x{bd}\x{d0}\x{be} \x{d0}\x{b4}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{bb}\x{d1}\x{8f}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d1}\x{84}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d0}\x{b3}\x{d1}\x{80}\x{d0}\x{b0}\x{d1}\x{84}\x{d0}\x{b8}\x{d0}\x{b8} \x{d0}\x{b8} \x{d0}\x{b3}\x{d0}\x{b8}\x{d1}\x{84}\x{d0}\x{ba}\x{d0}\x{b8} \x{d0}\x{ba} \x{d0}\x{bb}\x{d1}\x{8e}\x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{83}. \x{e2}\x{80}\x{a2} \x{d0}\x{a1}\x{d0}\x{bc}\x{d0}\x{be}\x{d1}\x{82}\x{d1}\x{80}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{84}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d1}\x{82}\x{d0}\x{b5}\x{d1}\x{85}, \x{d0}\x{ba}\x{d0}\x{be}\x{d0}\x{bc}\x{d1}\x{83} \x{d0}\x{bf}\x{d0}\x{be}\x{d0}\x{bd}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8}\x{d1}\x{81}\x{d1}\x{8c} \x{d0}\x{b2}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b8} \x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{b2}\x{d0}\x{b5}\x{d1}\x{82}\x{d1}\x{8b} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}. \x{e2}\x{80}\x{a2} \x{d0}\x{91}\x{d0}\x{b5}\x{d0}\x{b7}\x{d0}\x{be}\x{d0}\x{bf}\x{d0}\x{b0}\x{d1}\x{81}\x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{8f} \x{d1}\x{81}\x{d1}\x{80}\x{d0}\x{b5}\x{d0}\x{b4}\x{d0}\x{b0}, \x{d0}\x{b2} \x{d0}\x{ba}\x{d0}\x{be}\x{d1}\x{82}\x{d0}\x{be}\x{d1}\x{80}\x{d0}\x{be}\x{d0}\x{b9} \x{d0}\x{b2}\x{d1}\x{8b} \x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b6}\x{d0}\x{b5}\x{d1}\x{82}\x{d0}\x{b5} \x{d1}\x{81}\x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{be}\x{d0}\x{b4}\x{d0}\x{bd}\x{d0}\x{be} \x{d1}\x{81}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{be}\x{d0}\x{b2}\x{d1}\x{8b}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b6}\x{d0}\x{b0}\x{d1}\x{82}\x{d1}\x{8c}\x{d1}\x{81}\x{d1}\x{8f}. \x{e2}\x{80}\x{a2} \x{d0}\x{9e}\x{d1}\x{82}\x{d0}\x{ba}\x{d0}\x{bb}\x{d1}\x{8e}\x{d1}\x{87}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{be}\x{d1}\x{82} \x{d0}\x{b2}\x{d1}\x{81}\x{d0}\x{b5}\x{d1}\x{85}, \x{d0}\x{ba}\x{d1}\x{82}\x{d0}\x{be} \x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{bc} \x{d0}\x{bd}\x{d0}\x{b5} \x{d0}\x{bd}\x{d1}\x{80}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b8}\x{d1}\x{82}\x{d1}\x{81}\x{d1}\x{8f}. \x{d0}\x{95}\x{d1}\x{81}\x{d1}\x{82}\x{d1}\x{8c} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d0}\x{b1}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{bc}\x{d1}\x{8b} \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}? \x{d0}\x{97}\x{d0}\x{b0}\x{d1}\x{85}\x{d0}\x{be}\x{d0}\x{b4}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{bd}\x{d0}\x{b0} http://support.ask.fm \x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b8} \x{d0}\x{b7}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b} \x{d0}\x{bd}\x{d0}\x{b0} \x{d0}\x{bd}\x{d0}\x{b0}\x{d1}\x{88}\x{d0}\x{b5}\x{d0}\x{bc} \x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{84}\x{d0}\x{b8}\x{d0}\x{bb}\x{d0}\x{b5}: http://ask.fm/askfmhelp. \x{d0}\x{a1}\x{d0}\x{bb}\x{d0}\x{b5}\x{d0}\x{b4}\x{d0}\x{b8}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b7}\x{d0}\x{b0} \x{d0}\x{bd}\x{d0}\x{b0}\x{d0}\x{bc}\x{d0}\x{b8} \x{d0}\x{b2}: Instagram https://www.instagram.com/askfm/Facebook https://www.facebook.com/askfmpageTwitter https://twitter.com/askfmVKontakte https://vk.com/askfm",
                                        'rating'   => '4.106995106',
                                        'MTime'    => ['1517481975', '1517481975', '1517481975'],
                                        'currency' => 'RUB',
                                        'title_eng' =>
"ASKfm - \x{d0}\x{97}\x{d0}\x{b0}\x{d0}\x{b4}\x{d0}\x{b0}\x{d0}\x{b2}\x{d0}\x{b0}\x{d0}\x{b9}\x{d1}\x{82}\x{d0}\x{b5} \x{d0}\x{b0}\x{d0}\x{bd}\x{d0}\x{be}\x{d0}\x{bd}\x{d0}\x{b8}\x{d0}\x{bc}\x{d0}\x{bd}\x{d1}\x{8b}\x{d0}\x{b5} \x{d0}\x{b2}\x{d0}\x{be}\x{d0}\x{bf}\x{d1}\x{80}\x{d0}\x{be}\x{d1}\x{81}\x{d1}\x{8b}",
                                        'SimpleClickAnnotationMatchPrediction' => ['0', '0', '0'],
                                        'rating_votes'            => ['0.0242817',  '0.0242817',  '0.0242817'],
                                        'TR'                      => ['0.00735931', '0.00735931', '0.00735931'],
                                        'rating_count'            => '1214084',
                                        'LongClickSPBm15StrictK2' => ['0',          '0',          '0'],
                                        '_MimeType'               => '7 0&d=203&sh=-1&sg=',
                                        'Bclm2'                   => ['0',          '0',          '0'],
                                        'CorrectedCtrBm15V4K5'    => ['0',          '0',          '0'],
                                        'prefix'                  => '000000000000002A'
                                    }
                                }
                            ],
                            'relevance'  => '102113248',
                            'group_attr' => '',
                            'doccount'   => '1',
                            'found'      => {
                                'strict' => '1',
                                'phrase' => '1',
                                'all'    => '1'
                            }
                        }
                    ],
                    'attr'  => '',
                    'found' => {
                        'strict' => '1',
                        'phrase' => '1',
                        'all'    => '1'
                    }
                }
            ]
        },
        'groupings' => [
            {
                'groups-on-page' => '10',
                'mode'           => 'flat',
                'categ'          => '',
                'attr'           => '',
                'docs'           => '1'
            }
        ]
    };
}
