#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;
use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs restore_subs);
use Test::Partner::Utils;

my $MOCKED_TICKET = 'MOCKED_TVM_SERVICE_TICKET';

run_tests(
    sub {
        my ($app) = @_;

        my $LWPRequest = undef;
        {
            no warnings 'redefine';
            no strict 'refs';

            *{'LWP::UserAgent::request'} = sub {
                my ($mock, $request) = @_;

                $LWPRequest = $request;

                my $r = HTTP::Response->new(200);

                $r->request($request);
                $r->content('{"counter":{"id":1}}');

                return $r;
            };
        }

        # NOTE! По дефолту используется вьюха
        restore_subs([qw(Application::Model::PartnerDB::all_pages)]);

        # Наливаем
        $app->partner_db->all_pages->add_multi(
            [
                {
                    'domain'                => 'showmethemoney.ru',
                    'is_balance_registered' => TRUE,
                    'login'                 => 'mocked-yan-partner',
                    'model'                 => 'context_on_site_campaign',
                    'multistate'            => 16,
                    'page_id'               => 1
                },
            ]
        );

        mock_subs(
            {
                'Application::Model::API::Yandex::TVM::get_service_ticket' => sub {
                    return $MOCKED_TICKET;
                  }
            }
        );

        $app->do('metrika', 'create_page_counters');

        my $got = $LWPRequest ? $LWPRequest->as_string : '';

        my $expect = qq[POST https://api-metrika-test.metrika.yandex.net/management/v1/counters?uid=0
Content-Length: 110
Content-Type: application/json
X-Ya-Service-Ticket: $MOCKED_TICKET

{"counter":{"site":"showmethemoney.ru","partner_id":"1","name":"Page 1 (showmethemoney.ru)","type":"partner"}}
];
        eq_or_diff_http_message($got, $expect, "Request", {context => 10});

    },
    application_package => 'Cron',
    init                => [qw(api_tvm)],
);
